/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.mongodb.DuplicateKeyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.views.PluginMetadataSummary;
import org.graylog.plugins.views.search.views.ViewClusterConfig;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewRequirements;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.WriteResult;

public class ViewService
extends PaginatedDbService<ViewDTO> {
    private static final String COLLECTION_NAME = "views";
    private final ClusterConfigService clusterConfigService;
    private final ViewRequirements.Factory viewRequirementsFactory;

    @Inject
    protected ViewService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterConfigService clusterConfigService, ViewRequirements.Factory viewRequirementsFactory) {
        super(mongoConnection, mapper, ViewDTO.class, COLLECTION_NAME);
        this.clusterConfigService = clusterConfigService;
        this.viewRequirementsFactory = viewRequirementsFactory;
    }

    public PaginatedList<ViewDTO> searchPaginated(SearchQuery query, Predicate<ViewDTO> filter, String order, String sortField, int page, int perPage) {
        PaginatedList<ViewDTO> viewsList = this.findPaginatedWithQueryFilterAndSort(query.toDBQuery(), filter, this.getSortBuilder(order, sortField), page, perPage);
        return viewsList.stream().map(this::requirementsForView).collect(Collectors.toCollection(() -> new PaginatedList(new ArrayList(viewsList.size()), viewsList.pagination().total(), page, perPage)));
    }

    public void saveDefault(ViewDTO dto) {
        if (Strings.isNullOrEmpty((String)dto.id())) {
            throw new IllegalArgumentException("ViewDTO needs an ID to be configured as default view");
        }
        this.clusterConfigService.write(ViewClusterConfig.builder().defaultViewId(dto.id()).build());
    }

    public Optional<ViewDTO> getDefault() {
        return Optional.ofNullable(this.clusterConfigService.get(ViewClusterConfig.class)).flatMap(config -> this.get(config.defaultViewId()));
    }

    public Collection<ViewDTO> forSearch(String searchId) {
        return this.db.find(DBQuery.is((String)"search_id", (Object)searchId)).toArray().stream().map(this::requirementsForView).collect(Collectors.toSet());
    }

    @Override
    public Optional<ViewDTO> get(String id) {
        return super.get(id).map(this::requirementsForView);
    }

    @Override
    public Stream<ViewDTO> streamAll() {
        return super.streamAll().map(this::requirementsForView);
    }

    @Override
    public Stream<ViewDTO> streamByIds(Set<String> idSet) {
        return super.streamByIds(idSet).map(this::requirementsForView);
    }

    @Override
    public ViewDTO save(ViewDTO viewDTO) {
        try {
            WriteResult save = this.db.insert((Object)this.requirementsForView(viewDTO));
            return (ViewDTO)save.getSavedObject();
        }
        catch (DuplicateKeyException e) {
            throw new IllegalStateException("Unable to save view, it already exists.");
        }
    }

    public ViewDTO update(ViewDTO viewDTO) {
        Preconditions.checkArgument((viewDTO.id() != null ? 1 : 0) != 0, (Object)"Id of view must not be null.");
        ViewDTO viewWithRequirements = this.requirementsForView(viewDTO);
        this.db.updateById((Object)new ObjectId(viewWithRequirements.id()), (Object)viewWithRequirements);
        return viewWithRequirements;
    }

    private ViewDTO requirementsForView(ViewDTO view) {
        return this.viewRequirementsFactory.create(view).rebuildRequirements(ViewDTO::requires, (v, newRequirements) -> v.toBuilder().requires((Map<String, PluginMetadataSummary>)newRequirements).build());
    }
}

