/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.models.system.processing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import org.graylog2.rest.models.system.processing.AutoValue_ProcessingStatusSummary;
import org.graylog2.rest.models.system.processing.AutoValue_ProcessingStatusSummary_ReceiveTimes;
import org.graylog2.system.processing.ProcessingStatusDto;
import org.graylog2.system.processing.ProcessingStatusRecorder;
import org.joda.time.DateTime;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ProcessingStatusSummary {
    public static final String FIELD_RECEIVE_TIMES = "receive_times";

    @JsonProperty(value="receive_times")
    public abstract ReceiveTimes receiveTimes();

    public static Builder builder() {
        return Builder.create();
    }

    public static ProcessingStatusSummary of(ProcessingStatusRecorder processingStatusRecorder) {
        return ProcessingStatusSummary.builder().receiveTimes(ReceiveTimes.builder().ingest(processingStatusRecorder.getIngestReceiveTime()).postProcessing(processingStatusRecorder.getPostProcessingReceiveTime()).postIndexing(processingStatusRecorder.getPostIndexingReceiveTime()).build()).build();
    }

    public static ProcessingStatusSummary of(ProcessingStatusDto dto) {
        return ProcessingStatusSummary.builder().receiveTimes(ReceiveTimes.builder().ingest(dto.receiveTimes().ingest()).postProcessing(dto.receiveTimes().postProcessing()).postIndexing(dto.receiveTimes().postIndexing()).build()).build();
    }

    public abstract Builder toBuilder();

    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class ReceiveTimes {
        public static final String FIELD_INGEST = "ingest";
        public static final String FIELD_POST_PROCESSING = "post_processing";
        public static final String FIELD_POST_INDEXING = "post_indexing";

        @JsonProperty(value="ingest")
        public abstract DateTime ingest();

        @JsonProperty(value="post_processing")
        public abstract DateTime postProcessing();

        @JsonProperty(value="post_indexing")
        public abstract DateTime postIndexing();

        public static Builder builder() {
            return Builder.create();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_ProcessingStatusSummary_ReceiveTimes.Builder();
            }

            @JsonProperty(value="ingest")
            public abstract Builder ingest(DateTime var1);

            @JsonProperty(value="post_processing")
            public abstract Builder postProcessing(DateTime var1);

            @JsonProperty(value="post_indexing")
            public abstract Builder postIndexing(DateTime var1);

            public abstract ReceiveTimes build();
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_ProcessingStatusSummary.Builder();
        }

        @JsonProperty(value="receive_times")
        public abstract Builder receiveTimes(ReceiveTimes var1);

        public abstract ProcessingStatusSummary build();
    }
}

