/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.alerts;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.alerts.Alert;
import org.graylog2.alerts.AlertService;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.rest.models.streams.alerts.AlertListSummary;
import org.graylog2.rest.models.streams.alerts.AlertSummary;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@RequiresAuthentication
@Api(value="Alerts", description="Manage stream alerts for all streams")
@Path(value="/streams/alerts")
@Produces(value={"application/json"})
public class AlertResource
extends RestResource {
    private final StreamService streamService;
    private final AlertService alertService;

    @Inject
    public AlertResource(StreamService streamService, AlertService alertService) {
        this.streamService = streamService;
        this.alertService = alertService;
    }

    @GET
    @Timed
    @ApiOperation(value="Get the most recent alarms of all streams.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertListSummary listRecent(@ApiParam(name="since", value="Optional parameter to define a lower date boundary. (UNIX timestamp)", required=false) @QueryParam(value="since") @DefaultValue(value="0") @Min(value=0L) @Min(value=0L) int sinceTs, @ApiParam(name="limit", value="Maximum number of alerts to return.", required=false) @QueryParam(value="limit") @DefaultValue(value="300") @Min(value=1L) @Min(value=1L) int limit) throws NotFoundException {
        DateTime since = new DateTime((long)sinceTs * 1000L, DateTimeZone.UTC);
        List<AlertSummary> alerts = this.getAlertSummaries(this.alertService.loadRecentOfStreams(this.getAllowedStreamIds(), since, limit).stream());
        return AlertListSummary.create(alerts.size(), alerts);
    }

    @GET
    @Timed
    @Path(value="paginated")
    @ApiOperation(value="Get alarms of all streams, filtered by specifying limit and offset parameters.")
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertListSummary listPaginated(@ApiParam(name="skip", value="The number of elements to skip (offset).", required=true) @QueryParam(value="skip") @DefaultValue(value="0") int skip, @ApiParam(name="limit", value="The maximum number of elements to return.", required=true) @QueryParam(value="limit") @DefaultValue(value="300") int limit, @ApiParam(name="state", value="Alert state (resolved/unresolved)", required=false) @QueryParam(value="state") String state) {
        Alert.AlertState alertState;
        List<String> allowedStreamIds = this.getAllowedStreamIds();
        try {
            alertState = Alert.AlertState.fromString(state);
        }
        catch (IllegalArgumentException e) {
            alertState = Alert.AlertState.ANY;
        }
        Stream<Alert> alertsStream = this.alertService.listForStreamIds(allowedStreamIds, alertState, skip, limit).stream();
        List<AlertSummary> alerts = this.getAlertSummaries(alertsStream);
        return AlertListSummary.create(this.alertService.totalCountForStreams(allowedStreamIds, alertState), alerts);
    }

    @GET
    @Timed
    @Path(value="{alertId}")
    @ApiOperation(value="Get an alert by ID.")
    @ApiResponses(value={@ApiResponse(code=404, message="Alert not found."), @ApiResponse(code=400, message="Invalid ObjectId.")})
    public AlertSummary get(@ApiParam(name="alertId", value="The alert ID to retrieve.", required=true) @PathParam(value="alertId") String alertId) throws NotFoundException {
        Alert alert = this.alertService.load(alertId, "");
        this.checkPermission("streams:read", alert.getStreamId());
        return AlertSummary.create(alert.getId(), alert.getConditionId(), alert.getStreamId(), alert.getDescription(), alert.getConditionParameters(), alert.getTriggeredAt(), alert.getResolvedAt(), alert.isInterval());
    }

    private List<String> getAllowedStreamIds() {
        return this.streamService.loadAll().stream().filter(stream -> this.isPermitted("streams:read", stream.getId())).map(Persisted::getId).collect(Collectors.toList());
    }

    private List<AlertSummary> getAlertSummaries(Stream<Alert> alertStream) {
        return alertStream.map(alert -> AlertSummary.create(alert.getId(), alert.getConditionId(), alert.getStreamId(), alert.getDescription(), alert.getConditionParameters(), alert.getTriggeredAt(), alert.getResolvedAt(), alert.isInterval())).collect(Collectors.toList());
    }
}

