/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeNotFoundException;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.loggers.responses.LoggersSummary;
import org.graylog2.rest.models.system.loggers.responses.SubsystemSummary;
import org.graylog2.rest.resources.system.logs.RemoteLoggersResource;
import org.graylog2.shared.rest.resources.ProxiedResource;

@RequiresAuthentication
@Api(value="Cluster/System/Loggers", description="Cluster-wide access to internal Graylog loggers")
@Path(value="/cluster/system/loggers")
public class ClusterLoggersResource
extends ProxiedResource {
    @Inject
    public ClusterLoggersResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService) throws NodeNotFoundException {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
    }

    @GET
    @Timed
    @ApiOperation(value="List all loggers of all nodes and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Optional<LoggersSummary>> loggers() {
        return this.getForAllNodes(RemoteLoggersResource::loggers, this.createRemoteInterfaceProvider(RemoteLoggersResource.class));
    }

    @GET
    @Timed
    @Path(value="/subsystems")
    @ApiOperation(value="List all logger subsystems and their current levels")
    @Produces(value={"application/json"})
    public Map<String, Optional<SubsystemSummary>> subsystems() {
        return this.getForAllNodes(RemoteLoggersResource::subsystems, this.createRemoteInterfaceProvider(RemoteLoggersResource.class));
    }

    @PUT
    @Timed
    @Path(value="/{nodeId}/subsystems/{subsystem}/level/{level}")
    @ApiOperation(value="Set the loglevel of a whole subsystem", notes="Provided level is falling back to DEBUG if it does not exist")
    @ApiResponses(value={@ApiResponse(code=404, message="No such subsystem.")})
    @NoAuditEvent(value="proxy resource, audit event will be emitted on target nodes")
    public void setSubsystemLoggerLevel(@ApiParam(name="nodeId", required=true) @PathParam(value="nodeId") @NotEmpty String nodeId, @ApiParam(name="subsystem", required=true) @PathParam(value="subsystem") @NotEmpty String subsystemTitle, @ApiParam(name="level", required=true) @PathParam(value="level") @NotEmpty String level) throws NodeNotFoundException, IOException {
        Node node = this.nodeService.byNodeId(nodeId);
        RemoteLoggersResource remoteLoggersResource = this.remoteInterfaceProvider.get(node, this.authenticationToken, RemoteLoggersResource.class);
        remoteLoggersResource.setSubsystemLoggerLevel(subsystemTitle, level).execute();
    }
}

