/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.net.ssl.TrustManager;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.security.TrustAllX509TrustManager;
import org.graylog2.security.ldap.LdapConnector;
import org.graylog2.security.ldap.LdapSettingsService;
import org.graylog2.shared.security.ldap.LdapEntry;
import org.graylog2.shared.security.ldap.LdapSettings;
import org.graylog2.shared.users.Role;
import org.graylog2.shared.users.UserService;
import org.graylog2.users.RoleService;
import org.graylog2.users.UserImpl;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapUserAuthenticator
extends AuthenticatingRealm {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserAuthenticator.class);
    public static final String NAME = "legacy-ldap";
    private final LdapConnector ldapConnector;
    private final LdapSettingsService ldapSettingsService;
    private final RoleService roleService;
    private final DateTimeZone rootTimeZone;
    private final UserService userService;

    @Inject
    LdapUserAuthenticator(LdapConnector ldapConnector, LdapSettingsService ldapSettingsService, UserService userService, RoleService roleService, @Named(value="root_timezone") DateTimeZone rootTimeZone) {
        this.ldapConnector = ldapConnector;
        this.userService = userService;
        this.ldapSettingsService = ldapSettingsService;
        this.roleService = roleService;
        this.rootTimeZone = rootTimeZone;
        this.setAuthenticationTokenClass(UsernamePasswordToken.class);
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setCachingEnabled(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authtoken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authtoken;
        if (!this.isEnabled()) {
            LOG.trace("LDAP is disabled, skipping");
            return null;
        }
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        String principal = (String)token.getPrincipal();
        char[] tokenPassword = (char[])MoreObjects.firstNonNull((Object)token.getPassword(), (Object)new char[0]);
        String password = String.valueOf(tokenPassword);
        if (Strings.isNullOrEmpty((String)principal) || Strings.isNullOrEmpty((String)password)) {
            LOG.debug("Principal or password were empty. Not trying to look up a token in LDAP.");
            return null;
        }
        try (LdapNetworkConnection connection = this.openLdapConnection(ldapSettings);){
            if (null == connection) {
                LOG.error("Couldn't connect to LDAP directory");
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            LdapEntry userEntry = this.searchLdapUser(connection, principal, ldapSettings);
            if (userEntry == null) {
                LOG.debug("User {} not found in LDAP", (Object)principal);
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            boolean authenticated = this.ldapConnector.authenticate(connection, userEntry.getDn(), password);
            if (!authenticated) {
                LOG.info("Invalid credentials for user {} (DN {})", (Object)principal, (Object)userEntry.getDn());
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            User user = this.syncFromLdapEntry(userEntry, ldapSettings, principal);
            if (user == null) {
                LOG.error("Unable to sync LDAP user {} (DN {})", (Object)userEntry.getBindPrincipal(), (Object)userEntry.getDn());
                AuthenticationInfo authenticationInfo = null;
                return authenticationInfo;
            }
            SimpleAccount simpleAccount = new SimpleAccount((Object)principal, null, "ldap realm");
            return simpleAccount;
        }
        catch (LdapException e) {
            LOG.error("LDAP error", (Throwable)e);
            return null;
        }
        catch (CursorException e) {
            LOG.error("Unable to read LDAP entry", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Error during LDAP user account sync. Cannot log in user {}", (Object)principal, (Object)e);
        }
        return null;
    }

    protected LdapNetworkConnection openLdapConnection(LdapSettings ldapSettings) throws LdapException {
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(ldapSettings.getUri().getHost());
        config.setLdapPort(ldapSettings.getUri().getPort());
        config.setUseSsl(ldapSettings.getUri().getScheme().startsWith("ldaps"));
        config.setUseTls(ldapSettings.isUseStartTls());
        if (ldapSettings.isTrustAllCertificates()) {
            config.setTrustManagers(new TrustManager[]{new TrustAllX509TrustManager()});
        }
        config.setName(ldapSettings.getSystemUserName());
        config.setCredentials(ldapSettings.getSystemPassword());
        return this.ldapConnector.connect(config);
    }

    protected LdapEntry searchLdapUser(LdapNetworkConnection connection, String principal, LdapSettings ldapSettings) throws LdapException, CursorException {
        return this.ldapConnector.search(connection, ldapSettings.getSearchBase(), ldapSettings.getSearchPattern(), ldapSettings.getDisplayNameAttribute(), principal, ldapSettings.isActiveDirectory(), ldapSettings.getGroupSearchBase(), ldapSettings.getGroupIdAttribute(), ldapSettings.getGroupSearchPattern());
    }

    public boolean isEnabled() {
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        return ldapSettings != null && ldapSettings.isEnabled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public User syncLdapUser(String principal) {
        if (!this.isEnabled()) {
            LOG.trace("LDAP is disabled, skipping");
            return null;
        }
        LdapSettings ldapSettings = this.ldapSettingsService.load();
        if (Strings.isNullOrEmpty((String)principal)) {
            LOG.debug("Principal was empty. Not trying to sync user with LDAP.");
            return null;
        }
        try (LdapNetworkConnection connection = this.openLdapConnection(ldapSettings);){
            if (null == connection) {
                LOG.error("Couldn't connect to LDAP directory");
                User user = null;
                return user;
            }
            LdapEntry userEntry = this.searchLdapUser(connection, principal, ldapSettings);
            if (userEntry == null) {
                LOG.debug("User {} not found in LDAP", (Object)principal);
                User user = null;
                return user;
            }
            User user = this.syncFromLdapEntry(userEntry, ldapSettings, principal);
            if (user == null) {
                LOG.error("Unable to sync LDAP user {} (DN {})", (Object)userEntry.getBindPrincipal(), (Object)userEntry.getDn());
                User user2 = null;
                return user2;
            }
            User user3 = user;
            return user3;
        }
        catch (LdapException e) {
            LOG.error("LDAP error", (Throwable)e);
            return null;
        }
        catch (CursorException e) {
            LOG.error("Unable to read LDAP entry", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Error during LDAP user account sync. Cannot sync user {}", (Object)principal, (Object)e);
        }
        return null;
    }

    @Nullable
    @VisibleForTesting
    User syncFromLdapEntry(LdapEntry userEntry, LdapSettings ldapSettings, String username) {
        User user = this.userService.load(username);
        if (user == null) {
            user = this.userService.create();
        }
        this.updateFromLdap(user, userEntry, ldapSettings, username);
        try {
            this.userService.save(user);
        }
        catch (ValidationException e) {
            LOG.error("Cannot save user.", (Throwable)e);
            return null;
        }
        return user;
    }

    private void updateFromLdap(User user, LdapEntry userEntry, LdapSettings ldapSettings, String username) {
        String email;
        String displayNameAttribute = ldapSettings.getDisplayNameAttribute();
        String fullName = (String)MoreObjects.firstNonNull((Object)userEntry.get(displayNameAttribute), (Object)username);
        user.setName(username);
        user.setFullName(fullName);
        user.setExternal(true);
        if (user.getTimeZone() == null) {
            user.setTimeZone(this.rootTimeZone);
        }
        if (Strings.isNullOrEmpty((String)(email = userEntry.getEmail()))) {
            LOG.debug("No email address found for user {} in LDAP. Using {}@localhost", (Object)username, (Object)username);
            user.setEmail(username + "@localhost");
        } else {
            user.setEmail(email);
        }
        if (Strings.isNullOrEmpty((String)user.getHashedPassword())) {
            ((UserImpl)user).setHashedPassword("User synced from LDAP.");
        }
        HashSet translatedRoleIds = Sets.newHashSet((Iterable)Sets.union((Set)Sets.newHashSet((Object[])new String[]{ldapSettings.getDefaultGroupId()}), ldapSettings.getAdditionalDefaultGroupIds()));
        if (!userEntry.getGroups().isEmpty()) {
            try {
                Map<String, Role> roleNameToRole = this.roleService.loadAllLowercaseNameMap();
                for (String ldapGroupName : userEntry.getGroups()) {
                    String roleName = ldapSettings.getGroupMapping().get(ldapGroupName);
                    if (roleName == null) {
                        LOG.debug("User {}: No group mapping for ldap group <{}>", (Object)username, (Object)ldapGroupName);
                        continue;
                    }
                    Role role = roleNameToRole.get(roleName.toLowerCase(Locale.ENGLISH));
                    if (role != null) {
                        LOG.debug("User {}: Mapping ldap group <{}> to role <{}>", new Object[]{username, ldapGroupName, role.getName()});
                        translatedRoleIds.add(role.getId());
                        continue;
                    }
                    LOG.warn("User {}: No role found for ldap group <{}>", (Object)username, (Object)ldapGroupName);
                }
            }
            catch (NotFoundException e) {
                LOG.error("Unable to load user roles", (Throwable)e);
            }
        } else if (ldapSettings.getGroupMapping().isEmpty() || ldapSettings.getGroupSearchBase().isEmpty() || ldapSettings.getGroupSearchPattern().isEmpty() || ldapSettings.getGroupIdAttribute().isEmpty()) {
            translatedRoleIds.addAll(user.getRoleIds());
        }
        user.setRoleIds(translatedRoleIds);
        user.setPermissions(user.getPermissions());
    }
}

