/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jvm.ThreadDump;
import com.eaio.uuid.UUID;
import com.github.joschi.jadconfig.util.Size;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.StreamingOutput;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.rest.models.system.responses.LocalesResponse;
import org.graylog2.rest.models.system.responses.SystemJVMResponse;
import org.graylog2.rest.models.system.responses.SystemOverviewResponse;
import org.graylog2.rest.models.system.responses.SystemThreadDumpResponse;
import org.graylog2.shared.ServerVersion;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System", description="System information of this node.")
@Path(value="/system")
@Produces(value={"application/json"})
public class SystemResource
extends RestResource {
    private final ServerStatus serverStatus;
    private final ClusterId clusterId;

    @Inject
    public SystemResource(ServerStatus serverStatus, ClusterConfigService clusterConfigService) {
        this.serverStatus = serverStatus;
        this.clusterId = clusterConfigService.getOrDefault(ClusterId.class, ClusterId.create(UUID.nilUUID().toString()));
    }

    @GET
    @Timed
    @ApiOperation(value="Get system overview")
    public SystemOverviewResponse system() {
        this.checkPermission("system:read", this.serverStatus.getNodeId().toString());
        return SystemOverviewResponse.create("graylog-server", "Quantum Dog", this.serverStatus.getNodeId().toString(), this.clusterId.clusterId(), ServerVersion.VERSION.toString(), Tools.getISO8601String(this.serverStatus.getStartedAt()), this.serverStatus.isProcessing(), Tools.getLocalCanonicalHostname(), this.serverStatus.getLifecycle().getDescription().toLowerCase(Locale.ENGLISH), this.serverStatus.getLifecycle().getLoadbalancerStatus().toString().toLowerCase(Locale.ENGLISH), this.serverStatus.getTimezone().getID(), System.getProperty("os.name", "unknown") + " " + System.getProperty("os.version", "unknown"));
    }

    @GET
    @ApiOperation(value="Get JVM information")
    @Path(value="/jvm")
    @Timed
    public SystemJVMResponse jvm() {
        this.checkPermission("jvmstats:read", this.serverStatus.getNodeId().toString());
        Runtime runtime = Runtime.getRuntime();
        return SystemJVMResponse.create(this.bytesToValueMap(runtime.freeMemory()), this.bytesToValueMap(runtime.maxMemory()), this.bytesToValueMap(runtime.totalMemory()), this.bytesToValueMap(runtime.totalMemory() - runtime.freeMemory()), this.serverStatus.getNodeId().toString(), Tools.getPID(), Tools.getSystemInformation());
    }

    @GET
    @Timed
    @ApiOperation(value="Get a thread dump")
    @Path(value="/threaddump")
    public SystemThreadDumpResponse threaddump() {
        this.checkPermission("threads:dump", this.serverStatus.getNodeId().toString());
        ThreadDump threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        threadDump.dump((OutputStream)output);
        return SystemThreadDumpResponse.create(new String(output.toByteArray(), StandardCharsets.UTF_8));
    }

    @GET
    @Path(value="/threaddump")
    @Produces(value={"text/plain"})
    @Timed
    @ApiOperation(value="Get a thread dump as plain text")
    public StreamingOutput threadDumpAsText() {
        this.checkPermission("threads:dump", this.serverStatus.getNodeId().toString());
        return output -> new ThreadDump(ManagementFactory.getThreadMXBean()).dump(output);
    }

    @GET
    @ApiOperation(value="Get supported locales")
    @Path(value="/locales")
    @Timed
    public LocalesResponse locales() {
        return LocalesResponse.create(Locale.getAvailableLocales());
    }

    private Map<String, Long> bytesToValueMap(long bytes) {
        Size size = Size.bytes((long)bytes);
        return ImmutableMap.of((Object)"bytes", (Object)size.toBytes(), (Object)"kilobytes", (Object)size.toKilobytes(), (Object)"megabytes", (Object)size.toMegabytes());
    }
}

