/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.processing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.bson.types.ObjectId;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.processing.ProcessingStatusDto;
import org.graylog2.system.processing.ProcessingStatusRecorder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;

public class DBProcessingStatusService {
    static final String COLLECTION_NAME = "processing_status";
    private static final String FIELD_WRITTEN_MESSAGES_1M = "input_journal.written_messages_1m_rate";
    private static final String FIELD_UNCOMMITTED_ENTRIES = "input_journal.uncommitted_entries";
    private final String nodeId;
    private final JobSchedulerClock clock;
    private final Duration updateThreshold;
    private final double journalWriteRateThreshold;
    private final JacksonDBCollection<ProcessingStatusDto, ObjectId> db;

    @Inject
    public DBProcessingStatusService(MongoConnection mongoConnection, NodeId nodeId, JobSchedulerClock clock, @Named(value="processing_status_update_threshold") Duration updateThreshold, @Named(value="processing_status_journal_write_rate_threshold") int journalWriteRateThreshold, MongoJackObjectMapperProvider mapper) {
        this.nodeId = nodeId.toString();
        this.clock = clock;
        this.updateThreshold = updateThreshold;
        this.journalWriteRateThreshold = ((Number)journalWriteRateThreshold).doubleValue();
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), ProcessingStatusDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("node_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject("updated_at", (Object)1).append(FIELD_UNCOMMITTED_ENTRIES, (Object)1).append(FIELD_WRITTEN_MESSAGES_1M, (Object)1));
    }

    public List<ProcessingStatusDto> all() {
        return ImmutableList.copyOf((Iterator)this.db.find().sort((DBObject)DBSort.asc((String)"_id")).iterator());
    }

    public Optional<ProcessingStatusDto> get() {
        return Optional.ofNullable((ProcessingStatusDto)this.db.findOne(DBQuery.is((String)"node_id", (Object)this.nodeId)));
    }

    public Optional<DateTime> earliestPostIndexingTimestamp() {
        String sortField = "receive_times.post_indexing";
        DBQuery.Query query = DBProcessingStatusService.getDataSelectionQuery(this.clock, this.updateThreshold, this.journalWriteRateThreshold);
        try (DBCursor cursor = this.db.find(query).sort((DBObject)DBSort.asc((String)"receive_times.post_indexing")).limit(1);){
            if (cursor.hasNext()) {
                Optional<DateTime> optional = Optional.of(((ProcessingStatusDto)cursor.next()).receiveTimes().postIndexing());
                return optional;
            }
            Optional<DateTime> optional = Optional.empty();
            return optional;
        }
    }

    @VisibleForTesting
    static DBQuery.Query getDataSelectionQuery(JobSchedulerClock clock, Duration updateThreshold, double journalWriteRateThreshold) {
        DateTime updateThresholdTimestamp = clock.nowUTC().minus(updateThreshold.toMilliseconds());
        return DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.greaterThan((String)"updated_at", (Object)updateThresholdTimestamp), DBQuery.or((DBQuery.Query[])new DBQuery.Query[]{DBQuery.greaterThanEquals((String)FIELD_WRITTEN_MESSAGES_1M, (Object)journalWriteRateThreshold), DBQuery.greaterThanEquals((String)FIELD_UNCOMMITTED_ENTRIES, (Object)1L)})});
    }

    public ProcessingStatusDto save(ProcessingStatusRecorder processingStatusRecorder) {
        return this.save(processingStatusRecorder, DateTime.now((DateTimeZone)DateTimeZone.UTC));
    }

    @VisibleForTesting
    ProcessingStatusDto save(ProcessingStatusRecorder processingStatusRecorder, DateTime updatedAt) {
        return (ProcessingStatusDto)this.db.findAndModify(DBQuery.is((String)"node_id", (Object)this.nodeId), null, null, false, (Object)ProcessingStatusDto.of(this.nodeId, processingStatusRecorder, updatedAt), true, true);
    }
}

