/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.graylog.events.notifications.EventBacklogService;
import org.graylog.events.notifications.EventNotificationContext;
import org.graylog.events.notifications.EventNotificationModelData;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.scheduler.JobTriggerDto;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.configuration.EmailConfiguration;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.MessageSummary;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    private static final String UNKNOWN = "<unknown>";
    private final EmailConfiguration emailConfig;
    private final EmailRecipients.Factory emailRecipientsFactory;
    private final EventBacklogService eventBacklogService;
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final DBEventDefinitionService eventDefinitionService;
    private final ObjectMapper objectMapper;
    private final Engine templateEngine;

    @Inject
    public EmailSender(EmailConfiguration emailConfig, EmailRecipients.Factory emailRecipientsFactory, EventBacklogService eventBacklogService, NotificationService notificationService, NodeId nodeId, DBEventDefinitionService eventDefinitionService, ObjectMapper objectMapper, Engine templateEngine) {
        this.emailConfig = Objects.requireNonNull(emailConfig, "emailConfig");
        this.emailRecipientsFactory = Objects.requireNonNull(emailRecipientsFactory, "emailRecipientsFactory");
        this.eventBacklogService = eventBacklogService;
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
        this.eventDefinitionService = eventDefinitionService;
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper)");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
    }

    @VisibleForTesting
    private String buildSubject(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.subject()) ? "Graylog event notification: ${event_definition_title}" : config.subject();
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    private String buildBody(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.bodyTemplate()) ? "--- [Event Definition] ---------------------------\nTitle:       ${event_definition_title}\nDescription: ${event_definition_description}\nType:        ${event_definition_type}\n--- [Event] --------------------------------------\nTimestamp:            ${event.timestamp}\nMessage:              ${event.message}\nSource:               ${event.source}\nKey:                  ${event.key}\nPriority:             ${event.priority}\nAlert:                ${event.alert}\nTimestamp Processing: ${event.timestamp}\nTimerange Start:      ${event.timerange_start}\nTimerange End:        ${event.timerange_end}\nFields:\n${foreach event.fields field}  ${field.key}: ${field.value}\n${end}\n${if backlog}\n--- [Backlog] ------------------------------------\nLast messages accounting for this alert:\n${foreach backlog message}\n${message}\n\n${end}\n${end}\n\n" : config.bodyTemplate();
        return this.templateEngine.transform(template, model);
    }

    private Map<String, Object> getModel(EventNotificationContext ctx, ImmutableList<MessageSummary> backlog) {
        Optional<EventDefinitionDto> definitionDto = ctx.eventDefinition();
        Optional<JobTriggerDto> jobTriggerDto = ctx.jobTrigger();
        EventNotificationModelData modelData = EventNotificationModelData.builder().eventDefinitionId(definitionDto.map(EventDefinitionDto::id).orElse(UNKNOWN)).eventDefinitionType(definitionDto.map(d -> d.config().type()).orElse(UNKNOWN)).eventDefinitionTitle(definitionDto.map(EventDefinitionDto::title).orElse(UNKNOWN)).eventDefinitionDescription(definitionDto.map(EventDefinitionDto::description).orElse(UNKNOWN)).jobDefinitionId(jobTriggerDto.map(JobTriggerDto::jobDefinitionId).orElse(UNKNOWN)).jobTriggerId(jobTriggerDto.map(JobTriggerDto::id).orElse(UNKNOWN)).event(ctx.event()).backlog((List<MessageSummary>)backlog).build();
        return (Map)this.objectMapper.convertValue((Object)modelData, TypeReferences.MAP_STRING_OBJECT);
    }

    private void sendEmail(EmailEventNotificationConfig config, String emailAddress, Map<String, Object> model) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.emailConfig.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        SimpleEmail email = new SimpleEmail();
        email.setCharset("utf-8");
        if (Strings.isNullOrEmpty((String)this.emailConfig.getHostname())) {
            throw new TransportConfigurationException("No hostname configured for email transport while trying to send notification email!");
        }
        email.setHostName(this.emailConfig.getHostname());
        email.setSmtpPort(this.emailConfig.getPort());
        if (this.emailConfig.isUseSsl()) {
            email.setSslSmtpPort(Integer.toString(this.emailConfig.getPort()));
        }
        if (this.emailConfig.isUseAuth()) {
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(Strings.nullToEmpty((String)this.emailConfig.getUsername()), Strings.nullToEmpty((String)this.emailConfig.getPassword())));
        }
        if (Strings.isNullOrEmpty((String)config.sender())) {
            email.setFrom(this.emailConfig.getFromEmail());
        } else {
            email.setFrom(config.sender());
        }
        email.setSSLOnConnect(this.emailConfig.isUseSsl());
        email.setStartTLSEnabled(this.emailConfig.isUseTls());
        email.setSubject(this.buildSubject(config, model));
        email.setMsg(this.buildBody(config, model));
        email.addTo(emailAddress);
        email.send();
    }

    void sendEmails(EmailEventNotificationConfig notificationConfig, EventNotificationContext ctx, ImmutableList<MessageSummary> backlog) throws TransportConfigurationException, EmailException, ConfigurationError {
        if (!this.emailConfig.isEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        EmailRecipients emailRecipients = this.emailRecipientsFactory.create(new ArrayList<String>(notificationConfig.userRecipients()), new ArrayList<String>(notificationConfig.emailRecipients()));
        if (!this.emailConfig.isEnabled()) {
            LOG.debug("Email transport is not enabled in server configuration file!");
            return;
        }
        if (emailRecipients.isEmpty()) {
            LOG.debug("Cannot send emails: empty recipient list.");
            return;
        }
        Set<String> recipientsSet = emailRecipients.getEmailRecipients();
        if (recipientsSet.size() == 0) {
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.toString()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", "No recipients have been defined!").addDetail("description", "To fix this, go to the notification configuration and add at least one alert recipient.");
            this.notificationService.publishIfFirst(notification);
        }
        Map<String, Object> model = this.getModel(ctx, backlog);
        for (String email : recipientsSet) {
            this.sendEmail(notificationConfig, email, model);
        }
    }

    static class ConfigurationError
    extends Exception {
        ConfigurationError(String message) {
            super(message);
        }
    }
}

