/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.ViewService;
import org.graylog.plugins.views.search.views.sharing.UserShortSummary;
import org.graylog.plugins.views.search.views.sharing.ViewSharing;
import org.graylog.plugins.views.search.views.sharing.ViewSharingService;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.UserService;

@Api(value="Views/Sharing")
@Path(value="/views/{id}/share")
@Produces(value={"application/json"})
@RequiresAuthentication
public class ViewSharingResource
extends RestResource
implements PluginRestResource {
    private final ViewSharingService viewSharingService;
    private final ViewService viewService;
    private final UserService userService;

    @Inject
    public ViewSharingResource(ViewSharingService viewSharingService, ViewService viewService, UserService userService) {
        this.viewSharingService = viewSharingService;
        this.viewService = viewService;
        this.userService = userService;
    }

    @GET
    @ApiOperation(value="Get the sharing configuration for this view")
    public ViewSharing get(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        this.ensureUserIsPermittedForView(id);
        return this.viewSharingService.forView(id).orElseThrow(NotFoundException::new);
    }

    @POST
    @ApiOperation(value="Configure sharing for a view")
    @AuditEvent(type="views:view_sharing:create")
    public ViewSharing create(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id, ViewSharing viewSharing) {
        this.ensureUserIsPermittedForView(id);
        this.ensureUserIsPermittedToEditView(id);
        return this.viewSharingService.create(viewSharing);
    }

    @DELETE
    @ApiOperation(value="Delete sharing of a view")
    @AuditEvent(type="views:view_sharing:delete")
    public ViewSharing delete(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        this.ensureUserIsPermittedForView(id);
        this.ensureUserIsPermittedToEditView(id);
        return this.viewSharingService.remove(id).orElse(null);
    }

    @GET
    @Path(value="/users")
    @ApiOperation(value="Get a list of summaries of available users for sharing")
    public Set<UserShortSummary> summarizeUsers(@ApiParam(name="id") @PathParam(value="id") @NotEmpty String id) {
        List<User> users = this.userService.loadAll();
        String currentUser = this.getCurrentUser() != null ? this.getCurrentUser().getName() : null;
        return users.stream().filter(user -> !user.getName().equals(currentUser)).map(user -> UserShortSummary.create(user.getName(), user.getFullName())).collect(Collectors.toSet());
    }

    private void ensureUserIsPermittedForView(String viewId) {
        ViewDTO view = this.viewService.get(viewId).orElseThrow(NotFoundException::new);
        if (view.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.checkAnyPermission(new String[]{"dashboards:read", "view:read"}, viewId);
        } else {
            this.checkPermission("view:read", viewId);
        }
    }

    private void ensureUserIsPermittedToEditView(String viewId) {
        ViewDTO view = this.viewService.get(viewId).orElseThrow(NotFoundException::new);
        if (view.type().equals((Object)ViewDTO.Type.DASHBOARD)) {
            this.checkAnyPermission(new String[]{"dashboards:edit", "view:edit"}, viewId);
        } else {
            this.checkPermission("view:edit", viewId);
        }
    }
}

