/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.savedsearches;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.savedsearches.SavedSearch;
import org.graylog2.savedsearches.SavedSearchImpl;
import org.graylog2.savedsearches.SavedSearchService;
import org.joda.time.DateTime;

public class SavedSearchServiceImpl
extends PersistedServiceImpl
implements SavedSearchService {
    @Inject
    public SavedSearchServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
    }

    @Override
    public List<SavedSearch> all() {
        ArrayList searches = Lists.newArrayList();
        List<DBObject> results = this.query(SavedSearchImpl.class, (DBObject)new BasicDBObject());
        for (DBObject o : results) {
            searches.add(new SavedSearchImpl((ObjectId)o.get("_id"), o.toMap()));
        }
        return searches;
    }

    @Override
    public SavedSearch load(String id) throws NotFoundException {
        BasicDBObject o = (BasicDBObject)this.get(SavedSearchImpl.class, id);
        if (o == null) {
            throw new NotFoundException("Couldn't find saved search with ID " + id);
        }
        return new SavedSearchImpl((ObjectId)o.get("_id"), o.toMap());
    }

    @Override
    public SavedSearch create(String title, Map<String, Object> query, String creatorUserId, DateTime createdAt) {
        ImmutableMap searchData = ImmutableMap.of((Object)"title", (Object)title, (Object)"query", query, (Object)"creator_user_id", (Object)creatorUserId, (Object)"created_at", (Object)createdAt);
        return new SavedSearchImpl((Map<String, Object>)searchData);
    }

    @Override
    public void update(SavedSearch search, String title, Map<String, Object> query) throws ValidationException {
        if (title != null) {
            search.getFields().put("title", title);
        }
        if (query != null) {
            search.getFields().put("query", query);
        }
        this.save(search);
    }
}

