/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.urlwhitelist;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.regex.Pattern;
import org.graylog2.system.urlwhitelist.AutoValue_RegexWhitelistEntry;
import org.graylog2.system.urlwhitelist.WhitelistEntry;

@JsonAutoDetect
@AutoValue
public abstract class RegexWhitelistEntry
implements WhitelistEntry {
    protected Pattern cachedPattern() {
        return Pattern.compile(this.value(), 32);
    }

    @JsonCreator
    public static RegexWhitelistEntry create(@JsonProperty(value="id") String id, @JsonProperty(value="title") String title, @JsonProperty(value="value") String value) {
        return new AutoValue_RegexWhitelistEntry(id, WhitelistEntry.Type.REGEX, title, value);
    }

    @Override
    public boolean isWhitelisted(String url) {
        return this.cachedPattern().matcher(url).find();
    }
}

