/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.google.auto.value.AutoValue;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.events.event.Event;
import org.graylog.events.notifications.AutoValue_NotificationGracePeriodService_CacheKey;
import org.graylog.events.processor.EventDefinition;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationGracePeriodService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationGracePeriodService.class);
    private static final Duration CACHE_EXPIRY = Duration.ofMinutes(5L);
    private final LoadingCache<CacheKey, Optional<DateTime>> seenEvents = CacheBuilder.newBuilder().expireAfterAccess(CACHE_EXPIRY).build((CacheLoader)new CacheLoader<CacheKey, Optional<DateTime>>(){

        public Optional<DateTime> load(CacheKey key) {
            return Optional.ofNullable(null);
        }
    });

    @Inject
    public NotificationGracePeriodService() {
    }

    public boolean inGracePeriod(EventDefinition definition, String notificationId, Event event) {
        if (definition.notificationSettings().gracePeriodMs() <= 0L) {
            return false;
        }
        Optional<DateTime> lastEventTime = this.get(definition.id(), notificationId, event.toDto().key());
        if (lastEventTime.isPresent()) {
            return lastEventTime.get().isAfter((ReadableInstant)event.getEventTimestamp().minus(definition.notificationSettings().gracePeriodMs()));
        }
        this.put(definition.id(), notificationId, event.toDto().key(), event.getEventTimestamp());
        return false;
    }

    private Optional<DateTime> get(String eventDefinitionId, String notificationId, String eventKey) {
        try {
            return (Optional)this.seenEvents.get((Object)new AutoValue_NotificationGracePeriodService_CacheKey(eventDefinitionId, notificationId, eventKey));
        }
        catch (ExecutionException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOG.error("Unable to get seenEvent {}/{}/{} from cache", new Object[]{eventDefinitionId, notificationId, eventKey, rootCause});
            throw new RuntimeException(rootCause);
        }
    }

    private void put(String eventDefinitionId, String notificationId, String eventKey, DateTime time) {
        this.seenEvents.put((Object)new AutoValue_NotificationGracePeriodService_CacheKey(eventDefinitionId, notificationId, eventKey), Optional.of(time));
    }

    @AutoValue
    public static abstract class CacheKey {
        public abstract String eventDefinitionId();

        public abstract String notificationId();

        public abstract String eventKey();

        public static CacheKey create(String eventDefinitionId, String notificationId, String eventKey) {
            return new AutoValue_NotificationGracePeriodService_CacheKey(eventDefinitionId, notificationId, eventKey);
        }
    }
}

