/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.graph.Traverser;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.AutoValue_Query;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.engine.EmptyTimeRange;
import org.graylog.plugins.views.search.filter.AndFilter;
import org.graylog.plugins.views.search.filter.StreamFilter;
import org.graylog2.contentpacks.ContentPackable;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class Query
implements ContentPackable<QueryEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(Query.class);

    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract TimeRange timerange();

    @Nullable
    @JsonProperty
    public abstract Filter filter();

    @Nonnull
    @JsonProperty
    public abstract BackendQuery query();

    @JsonIgnore
    public abstract Optional<GlobalOverride> globalOverride();

    public TimeRange effectiveTimeRange(SearchType searchType) {
        return searchType.timerange().map(timeRange -> timeRange.effectiveTimeRange(this, searchType)).orElse(this.timerange());
    }

    @Nonnull
    @JsonProperty(value="search_types")
    public abstract ImmutableSet<SearchType> searchTypes();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return Builder.createWithDefaults();
    }

    Query applyExecutionState(ObjectMapper objectMapper, JsonNode state) {
        if (state.isMissingNode()) {
            return this;
        }
        boolean hasTimerange = state.hasNonNull("timerange");
        boolean hasQuery = state.hasNonNull("query");
        boolean hasSearchTypes = state.hasNonNull("search_types");
        boolean hasKeepSearchTypes = state.hasNonNull("keep_search_types");
        if (hasTimerange || hasQuery || hasSearchTypes || hasKeepSearchTypes) {
            Builder builder = this.toBuilder();
            if (hasTimerange || hasQuery) {
                GlobalOverride.Builder globalOverrideBuilder = this.globalOverride().map(GlobalOverride::toBuilder).orElseGet(GlobalOverride::builder);
                if (hasTimerange) {
                    try {
                        JsonNode rawTimerange = state.path("timerange");
                        TimeRange newTimeRange = (TimeRange)objectMapper.convertValue((Object)rawTimerange, TimeRange.class);
                        globalOverrideBuilder.timerange(newTimeRange);
                        builder.timerange(newTimeRange);
                    }
                    catch (Exception e) {
                        LOG.error("Unable to deserialize execution state for time range", (Throwable)e);
                    }
                }
                if (hasQuery) {
                    JsonNode rawQuery = state.path("query");
                    BackendQuery newQuery = (BackendQuery)objectMapper.convertValue((Object)rawQuery, BackendQuery.class);
                    globalOverrideBuilder.query(newQuery);
                    builder.query(newQuery);
                }
                builder.globalOverride(globalOverrideBuilder.build());
            }
            if (hasSearchTypes || hasKeepSearchTypes) {
                ImmutableSet<SearchType> searchTypesToKeep = hasKeepSearchTypes ? this.filterForWhiteListFromState((Set<SearchType>)this.searchTypes(), state) : this.searchTypes();
                Set<SearchType> searchTypesWithOverrides = this.applyAvailableOverrides(objectMapper, state, (Set<SearchType>)searchTypesToKeep);
                builder.searchTypes((Set<SearchType>)ImmutableSet.copyOf(searchTypesWithOverrides));
            }
            return builder.build();
        }
        return this;
    }

    private Set<SearchType> filterForWhiteListFromState(Set<SearchType> previousSearchTypes, JsonNode state) {
        Set<String> whitelist = this.parseSearchTypesWhitelistFrom(state);
        return previousSearchTypes.stream().filter(st -> whitelist.contains(st.id())).collect(Collectors.toSet());
    }

    private Set<String> parseSearchTypesWhitelistFrom(JsonNode state) {
        String key = "keep_search_types";
        HashSet<String> results = new HashSet<String>();
        if (state.has("keep_search_types") && state.get("keep_search_types").isArray()) {
            for (JsonNode n : state.get("keep_search_types")) {
                results.add(n.asText());
            }
        }
        return results;
    }

    private Set<SearchType> applyAvailableOverrides(ObjectMapper objectMapper, JsonNode state, Set<SearchType> searchTypes) {
        JsonNode searchTypesState = state.path("search_types");
        return searchTypes.stream().map(st -> {
            if (searchTypesState.has(st.id())) {
                return st.applyExecutionContext(objectMapper, searchTypesState.path(st.id()));
            }
            return st;
        }).collect(Collectors.toSet());
    }

    public static Query emptyRoot() {
        return Query.builder().id("").timerange(EmptyTimeRange.emptyTimeRange()).query(new BackendQuery.Fallback()).filter(null).build();
    }

    public Set<String> usedStreamIds() {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Traverser filterTraverser = Traverser.forTree(filter -> (Set)MoreObjects.firstNonNull(filter.filters(), Collections.emptySet()));
            return StreamSupport.stream(filterTraverser.breadthFirst(optFilter).spliterator(), false).filter(filter -> filter instanceof StreamFilter).map(streamFilter -> ((StreamFilter)streamFilter).streamId()).filter(Objects::nonNull).collect(Collectors.toSet());
        }).orElse(Collections.emptySet());
    }

    public boolean hasStreams() {
        return !this.usedStreamIds().isEmpty();
    }

    Query addStreamsToFilter(ImmutableSet<String> streamIds) {
        Filter newFilter = this.addStreamsTo(this.filter(), (Set<String>)streamIds);
        return this.toBuilder().filter(newFilter).build();
    }

    private Filter addStreamsTo(Filter filter, Set<String> streamIds) {
        Filter streamIdFilter = StreamFilter.anyIdOf(streamIds.toArray(new String[0]));
        if (filter == null) {
            return streamIdFilter;
        }
        return AndFilter.and(streamIdFilter, filter);
    }

    boolean hasSearchTypes() {
        return !this.searchTypes().isEmpty();
    }

    private Filter shallowMappedFilter(EntityDescriptorIds entityDescriptorIds) {
        return Optional.ofNullable(this.filter()).map(optFilter -> {
            Set<Filter> newFilters = optFilter.filters().stream().map(filter -> {
                if (filter.type().equals("stream")) {
                    StreamFilter streamFilter = (StreamFilter)filter;
                    String streamId = entityDescriptorIds.getOrThrow(streamFilter.streamId(), ModelTypes.STREAM_V1);
                    return streamFilter.toBuilder().streamId(streamId).build();
                }
                return filter;
            }).collect(Collectors.toSet());
            return optFilter.toGenericBuilder().filters(newFilters).build();
        }).orElse(null);
    }

    @Override
    public QueryEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return QueryEntity.builder().searchTypes(this.searchTypes().stream().map(s -> (SearchTypeEntity)s.toContentPackEntity(entityDescriptorIds)).collect(Collectors.toSet())).filter(this.shallowMappedFilter(entityDescriptorIds)).query(this.query()).id(this.id()).globalOverride(this.globalOverride().orElse(null)).timerange(this.timerange()).build();
    }

    @JsonPOJOBuilder(withPrefix="")
    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        @JsonProperty
        public abstract Builder timerange(TimeRange var1);

        @JsonProperty
        public abstract Builder filter(Filter var1);

        @JsonProperty
        public abstract Builder query(BackendQuery var1);

        public abstract Builder globalOverride(@Nullable GlobalOverride var1);

        @JsonProperty(value="search_types")
        public abstract Builder searchTypes(@Nullable Set<SearchType> var1);

        abstract Query autoBuild();

        @JsonCreator
        static Builder createWithDefaults() {
            return new AutoValue_Query.Builder().searchTypes((Set<SearchType>)ImmutableSortedSet.of());
        }

        public Query build() {
            return this.autoBuild();
        }
    }
}

