/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics.jersey2;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.ext.Provider;
import org.graylog2.shared.metrics.jersey2.AbstractMetricsFilter;

@Provider
@Priority(value=-2147483648)
public class TimedMetricsFilter
extends AbstractMetricsFilter {
    private final Timer timer;

    public TimedMetricsFilter(MetricRegistry metricRegistry, ResourceInfo resourceInfo) {
        Timed annotation = resourceInfo.getResourceMethod().getAnnotation(Timed.class);
        this.timer = metricRegistry.timer(this.chooseName(annotation.name(), annotation.absolute(), resourceInfo.getResourceMethod(), new String[0]));
    }

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        requestContext.setProperty("metricsTimerContext", (Object)this.timer.time());
    }

    @Override
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        Timer.Context context = (Timer.Context)requestContext.getProperty("metricsTimerContext");
        if (context == null) {
            return;
        }
        long elapsedNanos = context.stop();
        responseContext.getHeaders().add((Object)"X-Runtime-Microseconds", (Object)TimeUnit.NANOSECONDS.toMicros(elapsedNanos));
    }
}

