/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.web;

import com.floreysoft.jmte.Engine;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedMap;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.rest.RestTools;
import org.graylog2.web.PluginAssets;

@Singleton
public class IndexHtmlGenerator {
    private final String template;
    private final List<String> cssFiles;
    private final List<String> sortedJsFiles;
    private final Engine templateEngine;
    private final HttpConfiguration httpConfiguration;

    @Inject
    public IndexHtmlGenerator(PluginAssets pluginAssets, Engine templateEngine, HttpConfiguration httpConfiguration) throws IOException {
        this(Resources.toString((URL)Resources.getResource((String)"web-interface/index.html.template"), (Charset)StandardCharsets.UTF_8), pluginAssets.cssFiles(), pluginAssets.sortedJsFiles(), templateEngine, httpConfiguration);
    }

    private IndexHtmlGenerator(String template, List<String> cssFiles, List<String> sortedJsFiles, Engine templateEngine, HttpConfiguration httpConfiguration) throws IOException {
        this.template = Objects.requireNonNull(template, "template");
        this.cssFiles = Objects.requireNonNull(cssFiles, "cssFiles");
        this.sortedJsFiles = Objects.requireNonNull(sortedJsFiles, "sortedJsFiles");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration, "httpConfiguration");
    }

    public String get(MultivaluedMap<String, String> headers) {
        ImmutableMap model = ImmutableMap.builder().put((Object)"title", (Object)"Graylog Web Interface").put((Object)"cssFiles", this.cssFiles).put((Object)"jsFiles", this.sortedJsFiles).put((Object)"appPrefix", (Object)RestTools.buildExternalUri(headers, this.httpConfiguration.getHttpExternalUri())).build();
        return this.templateEngine.transform(this.template, (Map)model);
    }
}

