/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.netflow.codecs;

import com.google.common.base.MoreObjects;
import java.net.SocketAddress;
import java.util.Objects;

public class TemplateKey {
    private final SocketAddress remoteAddress;
    private final long sourceId;
    private final int templateId;

    public static TemplateKey idForExporter(SocketAddress remoteAddress, long sourceId) {
        return new TemplateKey(remoteAddress, sourceId, -1);
    }

    public TemplateKey(SocketAddress remoteAddress, long sourceId, int templateId) {
        this.remoteAddress = remoteAddress;
        this.sourceId = sourceId;
        this.templateId = templateId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateKey that = (TemplateKey)o;
        return this.sourceId == that.sourceId && this.templateId == that.templateId && Objects.equals(this.remoteAddress, that.remoteAddress);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public int getTemplateId() {
        return this.templateId;
    }

    public int hashCode() {
        return Objects.hash(this.remoteAddress, this.sourceId, this.templateId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("remoteAddress", (Object)this.remoteAddress).add("sourceId", this.sourceId).add("templateId", this.templateId).toString();
    }
}

