/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import org.graylog2.dashboards.widgets.WidgetResultCache;
import org.graylog2.dashboards.widgets.events.WidgetUpdatedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetEventsListener {
    private static final Logger LOG = LoggerFactory.getLogger(WidgetEventsListener.class);
    private final WidgetResultCache widgetResultCache;

    @Inject
    public WidgetEventsListener(WidgetResultCache widgetResultCache, EventBus eventBus) {
        this.widgetResultCache = widgetResultCache;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void invalidateWidgetResultCacheForWidgetUpdated(WidgetUpdatedEvent widgetUpdatedEvent) {
        LOG.debug("Invalidating widget <" + widgetUpdatedEvent.widgetId() + "> from WidgetResultCache due to WidgetUpdatedEvent");
        this.widgetResultCache.invalidate(widgetUpdatedEvent.widgetId());
    }
}

