/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.messageprocessors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.messageprocessors.$AutoValue_MessageProcessorsConfigWithDescriptors;
import org.graylog2.messageprocessors.MessageProcessorDescriptor;
import org.graylog2.messageprocessors.MessageProcessorsConfig;
import org.graylog2.plugin.messageprocessors.MessageProcessor;

@JsonAutoDetect
@AutoValue
public abstract class MessageProcessorsConfigWithDescriptors {
    @JsonProperty(value="processor_order")
    public abstract List<MessageProcessorDescriptor> processorOrder();

    @JsonProperty(value="disabled_processors")
    public abstract Set<String> disabledProcessors();

    @JsonCreator
    public static MessageProcessorsConfigWithDescriptors create(@JsonProperty(value="processor_order") List<MessageProcessorDescriptor> processorOrder, @JsonProperty(value="disabled_processors") Set<String> disabledProcessors) {
        return MessageProcessorsConfigWithDescriptors.builder().processorOrder(processorOrder).disabledProcessors(disabledProcessors).build();
    }

    public static MessageProcessorsConfigWithDescriptors fromConfig(MessageProcessorsConfig config, Set<MessageProcessor.Descriptor> descriptors) {
        Map<String, MessageProcessor.Descriptor> descriptorMap = descriptors.stream().collect(Collectors.toMap(MessageProcessor.Descriptor::className, descriptor -> descriptor));
        return MessageProcessorsConfigWithDescriptors.builder().processorOrder(config.processorOrder().stream().map(s -> MessageProcessorDescriptor.fromDescriptor((MessageProcessor.Descriptor)descriptorMap.get(s))).collect(Collectors.toList())).disabledProcessors(config.disabledProcessors()).build();
    }

    public MessageProcessorsConfig toConfig() {
        return MessageProcessorsConfig.builder().processorOrder(this.processorOrder().stream().map(MessageProcessorDescriptor::className).collect(Collectors.toList())).disabledProcessors(this.disabledProcessors()).build();
    }

    public static Builder builder() {
        return new $AutoValue_MessageProcessorsConfigWithDescriptors.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder processorOrder(List<MessageProcessorDescriptor> var1);

        public abstract Builder disabledProcessors(Set<String> var1);

        public abstract MessageProcessorsConfigWithDescriptors build();
    }
}

