/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.security.MongoDBSessionService;
import org.graylog2.security.MongoDbSession;

@Singleton
public class MongoDBSessionServiceImpl
extends PersistedServiceImpl
implements MongoDBSessionService {
    @Inject
    public MongoDBSessionServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
        MongoDatabase database = mongoConnection.getMongoDatabase();
        MongoCollection sessions = database.getCollection("sessions");
        sessions.createIndex(Indexes.ascending((String[])new String[]{"session_id"}));
    }

    @Override
    @Nullable
    public MongoDbSession load(String sessionId) {
        BasicDBObject query = new BasicDBObject();
        query.put("session_id", (Object)sessionId);
        DBObject result = this.findOne(MongoDbSession.class, (DBObject)query);
        if (result == null) {
            return null;
        }
        Object objectId = result.get("_id");
        return new MongoDbSession((ObjectId)objectId, result.toMap());
    }

    @Override
    public Collection<MongoDbSession> loadAll() {
        BasicDBObject query = new BasicDBObject();
        ArrayList dbSessions = Lists.newArrayList();
        List<DBObject> sessions = this.query(MongoDbSession.class, (DBObject)query);
        for (DBObject session : sessions) {
            dbSessions.add(new MongoDbSession((ObjectId)session.get("_id"), session.toMap()));
        }
        return dbSessions;
    }
}

