/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.activities;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.system.activities.SystemMessage;
import org.graylog2.system.activities.SystemMessageImpl;
import org.graylog2.system.activities.SystemMessageService;
import org.mongojack.DBSort;

public class SystemMessageServiceImpl
extends PersistedServiceImpl
implements SystemMessageService {
    private final int PER_PAGE = 30;

    @Inject
    public SystemMessageServiceImpl(MongoConnection mongoConnection) {
        super(mongoConnection);
        DBCollection collection = this.collection(SystemMessageImpl.class);
        collection.createIndex((DBObject)DBSort.desc((String)"timestamp"));
    }

    @Override
    public List<SystemMessage> all(int page) {
        ArrayList messages = Lists.newArrayList();
        BasicDBObject sort = new BasicDBObject();
        sort.put("timestamp", (Object)-1);
        List<DBObject> results = this.query(SystemMessageImpl.class, (DBObject)new BasicDBObject(), (DBObject)sort, 30, 30 * page);
        for (DBObject o : results) {
            messages.add(new SystemMessageImpl(new ObjectId(o.get("_id").toString()), o.toMap()));
        }
        return messages;
    }

    @Override
    public long totalCount() {
        return super.totalCount(SystemMessageImpl.class);
    }

    @Override
    public SystemMessage create(Map<String, Object> fields) {
        return new SystemMessageImpl(fields);
    }
}

