/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.codahale.metrics.MetricRegistry;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.search.AutoValue_MoreSearch_Result;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.elasticsearch.ESQueryDecorators;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.IndexRangeContainsOneOfStreams;
import org.graylog.plugins.views.search.errors.EmptyParameterError;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog2.Configuration;
import org.graylog2.database.NotFoundException;
import org.graylog2.indexer.IndexHelper;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.cluster.jest.JestUtils;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.indexer.ranges.IndexRangeService;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ScrollResult;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.plugin.streams.Stream;
import org.graylog2.streams.StreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSearch
extends Searches {
    private static final Logger LOG = LoggerFactory.getLogger(MoreSearch.class);
    private final StreamService streamService;
    private final IndexRangeService indexRangeService;
    private final ScrollResult.Factory scrollResultFactory;
    private final JestClient jestClient;
    private final boolean allowLeadingWildcardSearches;
    private final ESQueryDecorators esQueryDecorators;

    @Inject
    public MoreSearch(StreamService streamService, Indices indices, IndexRangeService indexRangeService, IndexSetRegistry indexSetRegistry, MetricRegistry metricRegistry, ScrollResult.Factory scrollResultFactory, JestClient jestClient, Configuration configuration, ESQueryDecorators esQueryDecorators) {
        super(configuration, indexRangeService, metricRegistry, streamService, indices, indexSetRegistry, jestClient, scrollResultFactory);
        this.streamService = streamService;
        this.indexRangeService = indexRangeService;
        this.scrollResultFactory = scrollResultFactory;
        this.jestClient = jestClient;
        this.allowLeadingWildcardSearches = configuration.isAllowLeadingWildcardSearches();
        this.esQueryDecorators = esQueryDecorators;
    }

    Result eventSearch(EventsSearchParameters parameters, String filterString, Set<String> eventStreams, Set<String> forbiddenSourceStreams) {
        Preconditions.checkArgument((parameters != null ? 1 : 0) != 0, (Object)"parameters cannot be null");
        Preconditions.checkArgument((!eventStreams.isEmpty() ? 1 : 0) != 0, (Object)"eventStreams cannot be empty");
        Preconditions.checkArgument((forbiddenSourceStreams != null ? 1 : 0) != 0, (Object)"forbiddenSourceStreams cannot be null");
        Sorting.Direction sortDirection = parameters.sortDirection() == EventsSearchParameters.SortDirection.ASC ? Sorting.Direction.ASC : Sorting.Direction.DESC;
        Sorting sorting = new Sorting(parameters.sortBy(), sortDirection);
        String queryString = parameters.query().trim();
        Set<String> affectedIndices = this.getAffectedIndices(eventStreams, parameters.timerange());
        MatchAllQueryBuilder query = queryString.isEmpty() || queryString.equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)queryString).allowLeadingWildcard(Boolean.valueOf(this.allowLeadingWildcardSearches));
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)query).filter((QueryBuilder)QueryBuilders.termsQuery((String)"streams", eventStreams)).filter(Objects.requireNonNull(IndexHelper.getTimestampRangeFilter(parameters.timerange())));
        if (!Strings.isNullOrEmpty((String)filterString)) {
            filter.filter((QueryBuilder)QueryBuilders.queryStringQuery((String)filterString));
        }
        if (!forbiddenSourceStreams.isEmpty()) {
            filter.filter((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"source_streams", forbiddenSourceStreams)));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)filter).from((parameters.page() - 1) * parameters.perPage()).size(parameters.perPage()).sort(sorting.getField(), sorting.asElastic());
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices)).allowNoIndices(false)).ignoreUnavailable(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString((ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchBuilder.build().toString());
        }
        SearchResult searchResult = this.wrapInMultiSearch(searchBuilder.build(), () -> "Unable to perform search query");
        List<ResultMessage> hits = searchResult.getHits(Map.class, false).stream().map(hit -> ResultMessage.parseFromSource(hit.id, hit.index, (Map)hit.source, hit.highlight)).collect(Collectors.toList());
        return Result.builder().results(hits).resultsCount(searchResult.getTotal()).duration(this.tookMsFromSearchResult((JestResult)searchResult)).usedIndexNames(affectedIndices).executedQuery(searchSourceBuilder.toString()).build();
    }

    private Set<String> getAffectedIndices(Set<String> streamIds, TimeRange timeRange) {
        SortedSet<IndexRange> indexRanges = this.indexRangeService.find(timeRange.getFrom(), timeRange.getTo());
        if (streamIds.isEmpty()) {
            return indexRanges.stream().map(IndexRange::indexName).collect(Collectors.toSet());
        }
        Set<Stream> streams = this.loadStreams(streamIds);
        IndexRangeContainsOneOfStreams indexRangeContainsOneOfStreams = new IndexRangeContainsOneOfStreams(streams);
        return indexRanges.stream().filter(indexRangeContainsOneOfStreams).map(IndexRange::indexName).collect(Collectors.toSet());
    }

    public void scrollQuery(String queryString, Set<String> streams, Set<Parameter> queryParameters, TimeRange timeRange, int batchSize, ScrollCallback resultCallback) throws EventProcessorException {
        String scrollTime = "1m";
        Set<String> affectedIndices = this.getAffectedIndices(streams, timeRange);
        try {
            queryString = this.decorateQuery(queryParameters, timeRange, queryString);
        }
        catch (SearchException e) {
            if (e.error() instanceof EmptyParameterError) {
                LOG.debug("Empty parameter from lookup table. Assuming non-matching query. Error: {}", (Object)e.getMessage());
                return;
            }
            throw e;
        }
        MatchAllQueryBuilder query = queryString.trim().isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery((String)queryString).allowLeadingWildcard(Boolean.valueOf(this.allowLeadingWildcardSearches));
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter((QueryBuilder)query).filter(Objects.requireNonNull(IndexHelper.getTimestampRangeFilter(timeRange)));
        if (!streams.isEmpty()) {
            filter.filter((QueryBuilder)QueryBuilders.termsQuery((String)"streams", streams));
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)filter).size(batchSize);
        Search.Builder searchBuilder = (Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addType("message")).addIndex(affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices)).addSort(new Sort("timestamp", Sort.Sorting.ASC)).allowNoIndices(false)).ignoreUnavailable(false)).setParameter("scroll", (Object)"1m");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString((ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchBuilder.build().toString());
        }
        SearchResult result = (SearchResult)JestUtils.execute(this.jestClient, searchBuilder.build(), () -> "Unable to scroll indices.");
        ScrollResult scrollResult = this.scrollResultFactory.create(result, searchSourceBuilder.toString(), "1m", Collections.emptyList());
        AtomicBoolean continueScrolling = new AtomicBoolean(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ScrollResult.ScrollChunk scrollChunk = scrollResult.nextChunk();
            while (continueScrolling.get() && scrollChunk != null) {
                List<ResultMessage> messages = scrollChunk.getMessages();
                LOG.debug("Passing <{}> messages to callback", (Object)messages.size());
                resultCallback.call(Collections.unmodifiableList(messages), continueScrolling);
                if (!continueScrolling.get()) {
                    break;
                }
                scrollChunk = scrollResult.nextChunk();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                scrollResult.cancel();
            }
            catch (Exception exception) {}
            LOG.debug("Scrolling done - took {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }

    public Set<Stream> loadStreams(Set<String> streamIds) {
        HashSet<Stream> streams = new HashSet<Stream>();
        for (String streamId : streamIds) {
            try {
                Stream load = this.streamService.load(streamId);
                streams.add(load);
            }
            catch (NotFoundException e) {
                LOG.debug("Failed to load stream <{}>", (Object)streamId);
            }
        }
        return streams;
    }

    private String decorateQuery(Set<Parameter> queryParameters, TimeRange timeRange, String queryString) {
        Search search = Search.builder().parameters((ImmutableSet<Parameter>)ImmutableSet.copyOf(queryParameters)).build();
        SearchJob searchJob = new SearchJob("1234", search, "events backend");
        Query dummyQuery = Query.builder().id("123").timerange(timeRange).query(ElasticsearchQueryString.builder().queryString(queryString).build()).build();
        return this.esQueryDecorators.decorate(queryString, searchJob, dummyQuery, (Set<QueryResult>)ImmutableSet.of());
    }

    @VisibleForTesting
    static String buildStreamFilter(Set<String> streams) {
        Preconditions.checkArgument((streams != null ? 1 : 0) != 0, (Object)"streams parameter cannot be null");
        Preconditions.checkArgument((!streams.isEmpty() ? 1 : 0) != 0, (Object)"streams parameter cannot be empty");
        String streamFilter = streams.stream().map(String::trim).map(stream -> String.format(Locale.ENGLISH, "streams:%s", stream)).collect(Collectors.joining(" OR "));
        return "(" + streamFilter + ")";
    }

    @AutoValue
    public static abstract class Result {
        public abstract List<ResultMessage> results();

        public abstract long resultsCount();

        public abstract long duration();

        public abstract Set<String> usedIndexNames();

        public abstract String executedQuery();

        public static Builder builder() {
            return new AutoValue_MoreSearch_Result.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder results(List<ResultMessage> var1);

            public abstract Builder resultsCount(long var1);

            public abstract Builder duration(long var1);

            public abstract Builder usedIndexNames(Set<String> var1);

            public abstract Builder executedQuery(String var1);

            public abstract Result build();
        }
    }

    public static interface ScrollCallback {
        public void call(List<ResultMessage> var1, AtomicBoolean var2) throws EventProcessorException;
    }
}

