/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.cef.codec;

import com.github.jcustenborder.cef.CEFParser;
import com.github.jcustenborder.cef.CEFParserFactory;
import com.github.jcustenborder.cef.Message;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.cef.parser.CEFMapping;
import org.graylog.plugins.cef.parser.MappedMessage;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogUtils;
import org.graylog2.plugin.ResolvableInetSocketAddress;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.configuration.fields.TextField;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.inputs.codecs.CodecAggregator;
import org.graylog2.plugin.journal.RawMessage;
import org.graylog2.shared.SuppressForbidden;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressForbidden(value="Intentionally use system default timezone")
public class CEFCodec
implements Codec {
    public static final String NAME = "CEF";
    private static final Logger LOG = LoggerFactory.getLogger(CEFCodec.class);
    private static final Pattern SYSLOG_PREFIX = Pattern.compile("^<(?<pri>\\d+)>(?<msg>.*)$");
    private static final String CK_TIMEZONE = "timezone";
    private static final String CK_LOCALE = "locale";
    private static final String CK_USE_FULL_NAMES = "use_full_names";
    private static final DateTimeZone DEFAULT_TIMEZONE = DateTimeZone.getDefault();
    private final Configuration configuration;
    private final DateTimeZone timezone;
    private final Locale locale;
    private final boolean useFullNames;
    private final CEFParser parser;

    @AssistedInject
    public CEFCodec(@Assisted Configuration configuration) {
        DateTimeZone timezone;
        this.configuration = configuration;
        this.parser = CEFParserFactory.create();
        try {
            timezone = DateTimeZone.forID((String)configuration.getString(CK_TIMEZONE));
        }
        catch (Exception e) {
            LOG.warn("Could not configure CEF input timezone. Falling back to local default. Please check the error message:", (Throwable)e);
            timezone = DEFAULT_TIMEZONE;
        }
        this.timezone = timezone;
        this.locale = Locale.forLanguageTag(configuration.getString(CK_LOCALE, ""));
        this.useFullNames = configuration.getBoolean(CK_USE_FULL_NAMES);
    }

    @Override
    @Nullable
    public org.graylog2.plugin.Message decode(@Nonnull RawMessage rawMessage) {
        String s = new String(rawMessage.getPayload(), StandardCharsets.UTF_8);
        Matcher matcher = SYSLOG_PREFIX.matcher(s);
        if (matcher.find()) {
            String priString = matcher.group("pri");
            Integer pri = Ints.tryParse((String)priString);
            HashMap<String, Object> syslogFields = new HashMap<String, Object>();
            if (pri != null) {
                int facility = SyslogUtils.facilityFromPriority(pri);
                syslogFields.put("level", SyslogUtils.levelFromPriority(pri));
                syslogFields.put("facility", SyslogUtils.facilityToString(facility));
            }
            String msg = matcher.group("msg");
            org.graylog2.plugin.Message message = this.decodeCEF(rawMessage, msg);
            message.addFields(syslogFields);
            return message;
        }
        return this.decodeCEF(rawMessage, s);
    }

    @Override
    public String getName() {
        return NAME;
    }

    protected org.graylog2.plugin.Message decodeCEF(@Nonnull RawMessage rawMessage, String s) {
        try {
            MappedMessage cef = new MappedMessage(this.parser.parse(s, this.timezone.toTimeZone(), this.locale), this.useFullNames);
            org.graylog2.plugin.Message result = new org.graylog2.plugin.Message(this.buildMessageSummary(cef), this.decideSource(cef, rawMessage), new DateTime((Object)cef.timestamp()));
            result.addFields(cef.mappedExtensions());
            result.addField("device_vendor", cef.deviceVendor());
            result.addField("device_product", cef.deviceProduct());
            result.addField("device_version", cef.deviceVersion());
            result.addField("event_class_id", cef.deviceEventClassId());
            result.addField("name", cef.name());
            result.addField("severity", cef.severity());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not decode CEF message.", e);
        }
    }

    protected String buildMessageSummary(Message cef) {
        return cef.deviceProduct() + ": [" + cef.deviceEventClassId() + ", " + cef.severity() + "] " + cef.name();
    }

    protected String decideSource(MappedMessage cef, RawMessage raw) {
        String deviceAddress;
        Map<String, Object> fields = cef.mappedExtensions();
        if (fields != null && !fields.isEmpty() && !Strings.isNullOrEmpty((String)(deviceAddress = (String)fields.getOrDefault(CEFMapping.dvc.getFullName(), fields.get(CEFMapping.dvc.getKeyName()))))) {
            return deviceAddress;
        }
        if (!Strings.isNullOrEmpty((String)cef.host())) {
            return cef.host();
        }
        ResolvableInetSocketAddress address = raw.getRemoteAddress();
        InetSocketAddress remoteAddress = address == null ? null : address.getInetSocketAddress();
        return remoteAddress == null ? "unknown" : remoteAddress.getAddress().toString();
    }

    @Override
    @Nullable
    public CodecAggregator getAggregator() {
        return null;
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @ConfigClass
    public static class Config
    implements Codec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest cr = new ConfigurationRequest();
            cr.addField(new TextField(CEFCodec.CK_TIMEZONE, "Timezone", DEFAULT_TIMEZONE.getID(), "Timezone of the timestamps in CEF messages. Set this to the local timezone if in doubt. Format example: \"+01:00\" or \"America/Chicago\"", ConfigurationField.Optional.NOT_OPTIONAL));
            cr.addField(new TextField(CEFCodec.CK_LOCALE, "Locale", "", "Locale to use for parsing the timestamps of CEF messages. Set this to english if in doubt. Format example: \"en\" or \"en_US\"", ConfigurationField.Optional.OPTIONAL));
            cr.addField(new BooleanField(CEFCodec.CK_USE_FULL_NAMES, "Use full field names", false, "Use full field names in CEF messages (as defined in the CEF specification)"));
            return cr;
        }

        @Override
        public void overrideDefaultValues(@Nonnull ConfigurationRequest cr) {
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<CEFCodec> {
        @Override
        public CEFCodec create(Configuration var1);

        @Override
        public Config getConfig();
    }
}

