/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.plugins.views.search.views.ViewDTO;
import org.graylog.plugins.views.search.views.sharing.IsViewSharedForUser;
import org.graylog.plugins.views.search.views.sharing.ViewSharing;
import org.graylog.plugins.views.search.views.sharing.ViewSharingService;
import org.graylog2.plugin.database.users.User;

public class ViewPermissionChecks {
    private final ViewSharingService viewSharingService;
    private final IsViewSharedForUser isViewSharedForUser;

    @Inject
    public ViewPermissionChecks(ViewSharingService viewSharingService, IsViewSharedForUser isViewSharedForUser) {
        this.viewSharingService = viewSharingService;
        this.isViewSharedForUser = isViewSharedForUser;
    }

    public boolean allowedToSeeSavedSearch(User user, ViewDTO savedSearch, BiPredicate<String, String> isPermitted) {
        return isPermitted.test("view:read", savedSearch.id()) || this.ownsView(user, savedSearch) || this.isSharedWithUser(user, savedSearch);
    }

    public boolean allowedToSeeDashboard(User user, ViewDTO dashboard, BiPredicate<String, String> isPermitted) {
        return isPermitted.test("view:read", dashboard.id()) || isPermitted.test("dashboards:read", dashboard.id()) || this.ownsView(user, dashboard) || this.isSharedWithUser(user, dashboard);
    }

    public boolean allowedToSeeView(User user, ViewDTO view, BiPredicate<String, String> isPermitted) {
        return this.isDashboard(view) ? this.allowedToSeeDashboard(user, view, isPermitted) : this.allowedToSeeSavedSearch(user, view, isPermitted);
    }

    boolean ownsView(@Nullable User currentUser, @Nullable ViewDTO view) {
        if (currentUser == null || view == null) {
            return false;
        }
        String name = currentUser.getName();
        if (name == null) {
            return false;
        }
        return view.owner().map(name::equals).orElse(false);
    }

    private boolean isSharedWithUser(User user, ViewDTO view) {
        Optional<ViewSharing> viewSharing = this.viewSharingService.forView(view.id());
        return viewSharing.map(sharing -> this.isViewSharedForUser.isAllowedToSee(user, (ViewSharing)sharing)).orElse(false);
    }

    boolean isDashboard(ViewDTO view) {
        return view != null && view.type().equals((Object)ViewDTO.Type.DASHBOARD);
    }
}

