/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views.sharing;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.graylog.plugins.views.search.views.sharing.SharingStrategy;
import org.graylog.plugins.views.search.views.sharing.SpecificRoles;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.Role;
import org.graylog2.users.RoleService;

public class SpecificRolesStrategy
implements SharingStrategy<SpecificRoles> {
    private final RoleService roleService;

    @Inject
    public SpecificRolesStrategy(RoleService roleService) {
        this.roleService = roleService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAllowedToSee(@Nullable User user, @NotNull SpecificRoles viewSharing) {
        Map<String, Role> roles;
        if (user == null) {
            return false;
        }
        if (user.isLocalAdmin()) {
            return true;
        }
        try {
            roles = this.roleService.loadAllIdMap();
        }
        catch (NotFoundException e) {
            return false;
        }
        Set userRoleNames = user.getRoleIds().stream().map(roles::get).filter(Objects::nonNull).map(Role::getName).collect(Collectors.toSet());
        if (user.isLocalAdmin()) return true;
        if (!viewSharing.roles().stream().anyMatch(userRoleNames::contains)) return false;
        return true;
    }
}

