/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.floreysoft.jmte.Engine;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.validation.constraints.NotEmpty;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.graylog2.lookup.adapters.$AutoValue_HTTPJSONPathDataAdapter_Config;
import org.graylog2.lookup.adapters.LookupDataAdapterValidationContext;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.system.urlwhitelist.UrlNotWhitelistedException;
import org.graylog2.system.urlwhitelist.UrlWhitelistNotificationService;
import org.graylog2.system.urlwhitelist.UrlWhitelistService;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPJSONPathDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPJSONPathDataAdapter.class);
    public static final String NAME = "httpjsonpath";
    private final Config config;
    private final Engine templateEngine;
    private final OkHttpClient httpClient;
    private final UrlWhitelistService urlWhitelistService;
    private final UrlWhitelistNotificationService urlWhitelistNotificationService;
    private final Timer httpRequestTimer;
    private final Meter httpRequestErrors;
    private final Meter httpURLErrors;
    private JsonPath singleJsonPath = null;
    private JsonPath multiJsonPath = null;
    private Headers headers;

    @Inject
    protected HTTPJSONPathDataAdapter(@Assisted(value="dto") DataAdapterDto dto, Engine templateEngine, OkHttpClient httpClient, UrlWhitelistService urlWhitelistService, UrlWhitelistNotificationService urlWhitelistNotificationService, MetricRegistry metricRegistry) {
        super(dto, metricRegistry);
        this.config = (Config)dto.config();
        this.templateEngine = templateEngine;
        this.httpClient = httpClient.newBuilder().build();
        this.urlWhitelistService = urlWhitelistService;
        this.urlWhitelistNotificationService = urlWhitelistNotificationService;
        this.httpRequestTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestTime"}));
        this.httpRequestErrors = metricRegistry.meter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestErrors"}));
        this.httpURLErrors = metricRegistry.meter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpURLErrors"}));
    }

    @Override
    protected void doStart() throws Exception {
        if (Strings.isNullOrEmpty((String)this.config.url())) {
            throw new IllegalArgumentException("URL needs to be set");
        }
        if (Strings.isNullOrEmpty((String)this.config.singleValueJSONPath())) {
            throw new IllegalArgumentException("Value JSONPath needs to be set");
        }
        this.singleJsonPath = JsonPath.compile((String)this.config.singleValueJSONPath(), (Predicate[])new Predicate[0]);
        if (!this.singleJsonPath.isDefinite()) {
            throw new IllegalArgumentException("Single JSONPath <" + this.config.singleValueJSONPath() + "> cannot return a list");
        }
        if (this.config.multiValueJSONPath().isPresent() && !Strings.isNullOrEmpty((String)this.config.multiValueJSONPath().get())) {
            this.multiJsonPath = JsonPath.compile((String)this.config.multiValueJSONPath().get(), (Predicate[])new Predicate[0]);
        }
        Headers.Builder headersBuilder = new Headers.Builder().add("User-Agent", this.config.userAgent()).add("Accept", "application/json");
        if (this.config.headers() != null) {
            this.config.headers().forEach((arg_0, arg_1) -> ((Headers.Builder)headersBuilder).set(arg_0, arg_1));
        }
        this.headers = headersBuilder.build();
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected LookupResult doGet(Object key) {
        String encodedKey;
        try {
            encodedKey = URLEncoder.encode(String.valueOf(key), "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException ignored) {
            encodedKey = String.valueOf(key);
        }
        String urlString = this.templateEngine.transform(this.config.url(), (Map)ImmutableMap.of((Object)"key", (Object)encodedKey));
        if (!this.urlWhitelistService.isWhitelisted(urlString)) {
            LOG.error("URL <{}> is not whitelisted. Aborting lookup request.", (Object)urlString);
            this.publishSystemNotificationForWhitelistFailure();
            this.setError(UrlNotWhitelistedException.forUrl(urlString));
            return this.getErrorResult();
        }
        this.clearError();
        HttpUrl url = HttpUrl.parse((String)urlString);
        if (url == null) {
            LOG.error("Couldn't parse URL <{}> - returning empty result", (Object)urlString);
            this.httpURLErrors.mark();
            return this.getErrorResult();
        }
        Request request = new Request.Builder().get().url(url).headers(this.headers).build();
        Timer.Context time = this.httpRequestTimer.time();
        try {
            LookupResult lookupResult;
            Object object;
            Response response;
            block35: {
                block36: {
                    LookupResult result;
                    block32: {
                        LookupResult lookupResult2;
                        block33: {
                            block34: {
                                block29: {
                                    LookupResult lookupResult3;
                                    block30: {
                                        block31: {
                                            response = this.httpClient.newCall(request).execute();
                                            object = null;
                                            if (response.isSuccessful()) break block29;
                                            LOG.warn("HTTP request for key <{}> failed: {}", key, (Object)response);
                                            this.httpRequestErrors.mark();
                                            lookupResult3 = this.getErrorResult();
                                            if (response == null) break block30;
                                            if (object == null) break block31;
                                            try {
                                                response.close();
                                            }
                                            catch (Throwable throwable) {
                                                ((Throwable)object).addSuppressed(throwable);
                                            }
                                            break block30;
                                        }
                                        response.close();
                                    }
                                    return lookupResult3;
                                }
                                result = HTTPJSONPathDataAdapter.parseBody(this.singleJsonPath, this.multiJsonPath, response.body().byteStream());
                                if (result != null) break block32;
                                lookupResult2 = this.getErrorResult();
                                if (response == null) break block33;
                                if (object == null) break block34;
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                                break block33;
                            }
                            response.close();
                        }
                        return lookupResult2;
                    }
                    lookupResult = result;
                    if (response == null) break block35;
                    if (object == null) break block36;
                    try {
                        response.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block35;
                }
                response.close();
            }
            return lookupResult;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (response != null) {
                            if (object != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                response.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    LOG.error("HTTP request error for key <{}>", key, (Object)e);
                    this.httpRequestErrors.mark();
                    object = this.getErrorResult();
                    return object;
                }
            }
        }
        finally {
            time.stop();
        }
    }

    @VisibleForTesting
    static LookupResult parseBody(JsonPath singleJsonPath, @Nullable JsonPath multiJsonPath, InputStream body) {
        try {
            DocumentContext documentContext = JsonPath.parse((InputStream)body);
            LookupResult.Builder builder = LookupResult.builder().cacheTTL(Long.MAX_VALUE);
            if (multiJsonPath != null) {
                try {
                    Object multiValue = documentContext.read(multiJsonPath);
                    if (multiValue instanceof Map) {
                        builder = builder.multiValue((Map)multiValue);
                    } else if (multiValue instanceof List) {
                        List<String> stringList = ((List)multiValue).stream().map(Object::toString).collect(Collectors.toList());
                        builder = builder.stringListValue(stringList);
                        builder = builder.multiSingleton(multiValue);
                    } else {
                        builder = builder.multiSingleton(multiValue);
                    }
                }
                catch (PathNotFoundException e) {
                    LOG.warn("Couldn't read multi JSONPath from response - skipping multi value ({})", (Object)e.getMessage());
                }
            }
            try {
                Object singleValue = documentContext.read(singleJsonPath);
                if (singleValue instanceof CharSequence) {
                    return builder.single((CharSequence)singleValue).build();
                }
                if (singleValue instanceof Number) {
                    return builder.single((Number)singleValue).build();
                }
                if (singleValue instanceof Boolean) {
                    return builder.single((Boolean)singleValue).build();
                }
                throw new IllegalArgumentException("Single value data type cannot be: " + singleValue.getClass().getCanonicalName());
            }
            catch (PathNotFoundException e) {
                LOG.warn("Couldn't read single JSONPath from response - returning empty result ({})", (Object)e.getMessage());
                return null;
            }
        }
        catch (InvalidJsonException e) {
            LOG.error("Couldn't parse JSON response", (Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            LOG.error("Couldn't assign value type", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("Unexpected error parsing JSON response", (Throwable)e);
            return null;
        }
    }

    @Override
    public void set(Object key, Object value) {
    }

    private synchronized void publishSystemNotificationForWhitelistFailure() {
        String description = "A \"HTTP JSONPath\" lookup adapter is trying to access a URL which is not whitelisted. Please check your configuration. [adapter name: \"" + this.name() + "\", url: \"" + this.config.url() + "\"]";
        this.urlWhitelistNotificationService.publishWhitelistFailure(description);
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_HTTPJSONPathDataAdapter_Config.Builder.class)
    @JsonTypeName(value="httpjsonpath")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="url")
        @NotEmpty
        public abstract String url();

        @JsonProperty(value="single_value_jsonpath")
        @NotEmpty
        public abstract String singleValueJSONPath();

        @JsonProperty(value="multi_value_jsonpath")
        public abstract Optional<String> multiValueJSONPath();

        @JsonProperty(value="user_agent")
        @NotEmpty
        public abstract String userAgent();

        @JsonProperty(value="headers")
        @Nullable
        public abstract Map<String, String> headers();

        public static Builder builder() {
            return new $AutoValue_HTTPJSONPathDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate(LookupDataAdapterValidationContext validationContext) {
            ArrayListMultimap errors = ArrayListMultimap.create();
            if (HttpUrl.parse((String)this.url()) == null) {
                errors.put((Object)"url", (Object)"Invalid URL.");
            } else if (!validationContext.getUrlWhitelistService().isWhitelisted(this.url())) {
                errors.put((Object)"url", (Object)("URL <" + this.url() + "> is not whitelisted."));
            }
            try {
                JsonPath jsonPath = JsonPath.compile((String)this.singleValueJSONPath(), (Predicate[])new Predicate[0]);
                if (!jsonPath.isDefinite()) {
                    errors.put((Object)"single_value_jsonpath", (Object)"JSONPath does not return a single value.");
                }
            }
            catch (InvalidPathException e) {
                errors.put((Object)"single_value_jsonpath", (Object)"Invalid JSONPath.");
            }
            if (this.multiValueJSONPath().isPresent()) {
                try {
                    JsonPath.compile((String)this.multiValueJSONPath().get(), (Predicate[])new Predicate[0]);
                }
                catch (InvalidPathException e) {
                    errors.put((Object)"multi_value_jsonpath", (Object)"Invalid JSONPath.");
                }
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="url")
            public abstract Builder url(String var1);

            @JsonProperty(value="single_value_jsonpath")
            public abstract Builder singleValueJSONPath(String var1);

            @JsonProperty(value="multi_value_jsonpath")
            public abstract Builder multiValueJSONPath(String var1);

            @JsonProperty(value="user_agent")
            public abstract Builder userAgent(String var1);

            @JsonProperty(value="headers")
            public abstract Builder headers(Map<String, String> var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(HTTPJSONPathDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(HTTPJSONPathDataAdapter.NAME).url("").singleValueJSONPath("$.value").userAgent("Graylog Lookup - https://www.graylog.org/").headers(Collections.emptyMap()).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory2<HTTPJSONPathDataAdapter> {
        @Override
        public HTTPJSONPathDataAdapter create(@Assisted(value="dto") DataAdapterDto var1);

        @Override
        public Descriptor getDescriptor();
    }
}

