/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Serializable;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.security.AutoValue_UserSessionTerminationService_GlobalTerminationRevisionConfig;
import org.graylog2.security.MongoDbSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserSessionTerminationService
extends AbstractIdleService {
    private static final long TERMINATION_REVISION = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(UserSessionTerminationService.class);
    private final MongoDbSessionDAO sessionDao;
    private final DefaultSecurityManager securityManager;
    private final ClusterConfigService clusterConfigService;
    private final ServerStatus serverStatus;

    @Inject
    public UserSessionTerminationService(MongoDbSessionDAO sessionDao, DefaultSecurityManager securityManager, ClusterConfigService clusterConfigService, ServerStatus serverStatus) {
        this.sessionDao = sessionDao;
        this.securityManager = securityManager;
        this.clusterConfigService = clusterConfigService;
        this.serverStatus = serverStatus;
    }

    protected void startUp() throws Exception {
        try {
            this.runGlobalSessionTermination();
        }
        catch (Exception e) {
            LOG.error("Couldn't run global session termination", (Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
    }

    private boolean isNotPrimaryNode() {
        return !this.serverStatus.hasCapability(ServerStatus.Capability.MASTER);
    }

    private void runGlobalSessionTermination() {
        if (this.isNotPrimaryNode()) {
            LOG.debug("Only run on the primary node to avoid concurrent session termination");
            return;
        }
        GlobalTerminationRevisionConfig globalTerminationRevisionConfig = this.clusterConfigService.getOrDefault(GlobalTerminationRevisionConfig.class, GlobalTerminationRevisionConfig.initial());
        if (!globalTerminationRevisionConfig.isOutdated()) {
            LOG.debug("Global session termination not required");
            return;
        }
        long terminatedSessions = 0L;
        for (Session activeSession : this.sessionDao.getActiveSessions()) {
            this.terminateSessionForID(activeSession.getId());
            ++terminatedSessions;
        }
        LOG.info("Globally terminated {} session(s)", (Object)terminatedSessions);
        this.clusterConfigService.write(GlobalTerminationRevisionConfig.withCurrentRevision());
    }

    private void terminateSessionForID(Serializable sessionId) {
        try {
            this.getActiveSessionForID(sessionId).ifPresent(Session::stop);
        }
        catch (Exception e) {
            LOG.error("Couldn't terminate session", (Throwable)e);
        }
    }

    private Optional<Session> getActiveSessionForID(Serializable sessionId) {
        SessionManager sessionManager = this.securityManager.getSessionManager();
        try {
            return Optional.ofNullable(sessionManager.getSession((SessionKey)new DefaultSessionKey(sessionId)));
        }
        catch (ExpiredSessionException e) {
            return Optional.empty();
        }
    }

    @AutoValue
    public static abstract class GlobalTerminationRevisionConfig {
        @JsonProperty(value="applied_revision")
        public abstract long appliedRevision();

        public static GlobalTerminationRevisionConfig initial() {
            return GlobalTerminationRevisionConfig.create(0L);
        }

        public static GlobalTerminationRevisionConfig withCurrentRevision() {
            return GlobalTerminationRevisionConfig.create(1L);
        }

        @JsonIgnore
        public boolean isOutdated() {
            return this.appliedRevision() < 1L;
        }

        @JsonCreator
        public static GlobalTerminationRevisionConfig create(@JsonProperty(value="applied_revision") long appliedRevision) {
            return new AutoValue_UserSessionTerminationService_GlobalTerminationRevisionConfig(appliedRevision);
        }
    }
}

