/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog2.contentpacks.model.entities.PivotEntity;

final class AutoValue_PivotEntity
extends PivotEntity {
    private final Optional<DerivedTimeRange> timerange;
    private final Optional<BackendQuery> query;
    private final Set<String> streams;
    private final String type;
    private final String id;
    private final Optional<String> name;
    private final List<BucketSpec> rowGroups;
    private final List<BucketSpec> columnGroups;
    private final List<SeriesSpec> series;
    private final List<SortSpec> sort;
    private final boolean rollup;
    private final Filter filter;

    private AutoValue_PivotEntity(Optional<DerivedTimeRange> timerange, Optional<BackendQuery> query, Set<String> streams, String type, @Nullable String id, Optional<String> name, List<BucketSpec> rowGroups, List<BucketSpec> columnGroups, List<SeriesSpec> series, List<SortSpec> sort, boolean rollup, @Nullable Filter filter) {
        this.timerange = timerange;
        this.query = query;
        this.streams = streams;
        this.type = type;
        this.id = id;
        this.name = name;
        this.rowGroups = rowGroups;
        this.columnGroups = columnGroups;
        this.series = series;
        this.sort = sort;
        this.rollup = rollup;
        this.filter = filter;
    }

    @Override
    @JsonProperty
    public Optional<DerivedTimeRange> timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    public Optional<BackendQuery> query() {
        return this.query;
    }

    @Override
    @JsonProperty
    public Set<String> streams() {
        return this.streams;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public Optional<String> name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="row_groups")
    public List<BucketSpec> rowGroups() {
        return this.rowGroups;
    }

    @Override
    @JsonProperty(value="column_groups")
    public List<BucketSpec> columnGroups() {
        return this.columnGroups;
    }

    @Override
    @JsonProperty
    public List<SeriesSpec> series() {
        return this.series;
    }

    @Override
    @JsonProperty
    public List<SortSpec> sort() {
        return this.sort;
    }

    @Override
    @JsonProperty
    public boolean rollup() {
        return this.rollup;
    }

    @Override
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return "PivotEntity{timerange=" + this.timerange + ", query=" + this.query + ", streams=" + this.streams + ", type=" + this.type + ", id=" + this.id + ", name=" + this.name + ", rowGroups=" + this.rowGroups + ", columnGroups=" + this.columnGroups + ", series=" + this.series + ", sort=" + this.sort + ", rollup=" + this.rollup + ", filter=" + this.filter + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PivotEntity) {
            PivotEntity that = (PivotEntity)o;
            return this.timerange.equals(that.timerange()) && this.query.equals(that.query()) && this.streams.equals(that.streams()) && this.type.equals(that.type()) && (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.name.equals(that.name()) && this.rowGroups.equals(that.rowGroups()) && this.columnGroups.equals(that.columnGroups()) && this.series.equals(that.series()) && this.sort.equals(that.sort()) && this.rollup == that.rollup() && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.name.hashCode();
        h$ *= 1000003;
        h$ ^= this.rowGroups.hashCode();
        h$ *= 1000003;
        h$ ^= this.columnGroups.hashCode();
        h$ *= 1000003;
        h$ ^= this.series.hashCode();
        h$ *= 1000003;
        h$ ^= this.sort.hashCode();
        h$ *= 1000003;
        h$ ^= this.rollup ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.filter == null ? 0 : this.filter.hashCode();
    }

    @Override
    public PivotEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends PivotEntity.Builder {
        private Optional<DerivedTimeRange> timerange = Optional.empty();
        private Optional<BackendQuery> query = Optional.empty();
        private Set<String> streams;
        private String type;
        private String id;
        private Optional<String> name = Optional.empty();
        private List<BucketSpec> rowGroups;
        private List<BucketSpec> columnGroups;
        private List<SeriesSpec> series;
        private List<SortSpec> sort;
        private Boolean rollup;
        private Filter filter;

        Builder() {
        }

        private Builder(PivotEntity source) {
            this.timerange = source.timerange();
            this.query = source.query();
            this.streams = source.streams();
            this.type = source.type();
            this.id = source.id();
            this.name = source.name();
            this.rowGroups = source.rowGroups();
            this.columnGroups = source.columnGroups();
            this.series = source.series();
            this.sort = source.sort();
            this.rollup = source.rollup();
            this.filter = source.filter();
        }

        @Override
        public PivotEntity.Builder timerange(@Nullable DerivedTimeRange timerange) {
            this.timerange = Optional.ofNullable(timerange);
            return this;
        }

        @Override
        public PivotEntity.Builder query(@Nullable BackendQuery query) {
            this.query = Optional.ofNullable(query);
            return this;
        }

        @Override
        public PivotEntity.Builder streams(Set<String> streams) {
            if (streams == null) {
                throw new NullPointerException("Null streams");
            }
            this.streams = streams;
            return this;
        }

        @Override
        public PivotEntity.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public PivotEntity.Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @Override
        public PivotEntity.Builder name(@Nullable String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        public PivotEntity.Builder rowGroups(@Nullable List<BucketSpec> rowGroups) {
            if (rowGroups == null) {
                throw new NullPointerException("Null rowGroups");
            }
            this.rowGroups = rowGroups;
            return this;
        }

        @Override
        public PivotEntity.Builder columnGroups(@Nullable List<BucketSpec> columnGroups) {
            if (columnGroups == null) {
                throw new NullPointerException("Null columnGroups");
            }
            this.columnGroups = columnGroups;
            return this;
        }

        @Override
        public PivotEntity.Builder series(List<SeriesSpec> series) {
            if (series == null) {
                throw new NullPointerException("Null series");
            }
            this.series = series;
            return this;
        }

        @Override
        public PivotEntity.Builder sort(List<SortSpec> sort) {
            if (sort == null) {
                throw new NullPointerException("Null sort");
            }
            this.sort = sort;
            return this;
        }

        @Override
        public PivotEntity.Builder rollup(boolean rollup) {
            this.rollup = rollup;
            return this;
        }

        @Override
        public PivotEntity.Builder filter(@Nullable Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public PivotEntity build() {
            String missing = "";
            if (this.streams == null) {
                missing = missing + " streams";
            }
            if (this.type == null) {
                missing = missing + " type";
            }
            if (this.rowGroups == null) {
                missing = missing + " rowGroups";
            }
            if (this.columnGroups == null) {
                missing = missing + " columnGroups";
            }
            if (this.series == null) {
                missing = missing + " series";
            }
            if (this.sort == null) {
                missing = missing + " sort";
            }
            if (this.rollup == null) {
                missing = missing + " rollup";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PivotEntity(this.timerange, this.query, this.streams, this.type, this.id, this.name, this.rowGroups, this.columnGroups, this.series, this.sort, this.rollup, this.filter);
        }
    }
}

