/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog2.indexer.results.IndexQueryResult;

public class TermsResult
extends IndexQueryResult {
    private final long total;
    private final long missing;
    private final long other;
    private final Map<String, Long> terms = new HashMap<String, Long>();
    private final Map<String, List<Map<String, String>>> termsMapping = new HashMap<String, List<Map<String, String>>>();

    public TermsResult(TermsAggregation terms, long missingCount, long totalCount, String originalQuery, String builtQuery, long tookMs) {
        this(terms, missingCount, totalCount, originalQuery, builtQuery, tookMs, Collections.emptyList());
    }

    public TermsResult(TermsAggregation terms, long missingCount, long totalCount, String originalQuery, String builtQuery, long tookMs, List<String> fields) {
        super(originalQuery, builtQuery, tookMs);
        this.total = totalCount;
        this.missing = missingCount;
        this.other = terms.getSumOtherDocCount();
        TermsResult.processTermsBuckets(terms, fields, this.terms, this.termsMapping);
    }

    private TermsResult(String originalQuery, String builtQuery) {
        super(originalQuery, builtQuery, 0L);
        this.total = 0L;
        this.missing = 0L;
        this.other = 0L;
    }

    private static void processTermsBuckets(TermsAggregation buckets, List<String> fields, Map<String, Long> terms, Map<String, List<Map<String, String>>> termsMapping) {
        for (TermsAggregation.Entry entry : buckets.getBuckets()) {
            List valueList = Splitter.on((String)"\u2e31").splitToList((CharSequence)entry.getKey());
            String value = entry.getKey().replace("\u2e31", " - ");
            ImmutableList.Builder mapping = ImmutableList.builder();
            for (int i = 0; i < fields.size(); ++i) {
                mapping.add((Object)ImmutableMap.of((Object)"field", (Object)fields.get(i), (Object)"value", (Object)((String)valueList.get(i))));
            }
            terms.put(value, entry.getCount());
            termsMapping.put(value, (List<Map<String, String>>)mapping.build());
        }
    }

    public static TermsResult empty(String originalQuery, String builtQuery) {
        return new TermsResult(originalQuery, builtQuery);
    }

    public long getTotal() {
        return this.total;
    }

    public long getMissing() {
        return this.missing;
    }

    public long getOther() {
        return this.other;
    }

    public Map<String, Long> getTerms() {
        return this.terms;
    }

    public Map<String, List<Map<String, String>>> termsMapping() {
        return this.termsMapping;
    }
}

