/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.debug;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Debug
extends AbstractFunction<Void> {
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("The value to print in the graylog-server log.").build();
    public static final String NAME = "debug";

    Debug() {
    }

    @Override
    public Void evaluate(FunctionArgs args, EvaluationContext context) {
        Object value = this.valueParam.required(args, context);
        if (value == null) {
            log.info("PIPELINE DEBUG: Passed value is NULL.");
        } else {
            log.info("PIPELINE DEBUG: {}", (Object)value.toString());
        }
        return null;
    }

    @Override
    public FunctionDescriptor<Void> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Void.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam)).description("Print any passed value as string in the graylog-server log. Note that this will only appear in the log of the graylog-server node that is processing the message you are trying to debug.").build();
    }
}

