/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine;

import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.errors.SearchException;
import org.graylog.plugins.views.search.errors.SearchTypeError;

public interface SearchTypeHandler<S extends SearchType, Q, R> {
    default public void generateQueryPart(SearchJob job, Query query, SearchType searchType, Q queryContext) {
        try {
            this.doGenerateQueryPart(job, query, searchType, queryContext);
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SearchException(new SearchTypeError(query, searchType.id(), t));
        }
    }

    public void doGenerateQueryPart(SearchJob var1, Query var2, S var3, Q var4);

    default public SearchType.Result extractResult(SearchJob job, Query query, SearchType searchType, R queryResult, Q queryContext) {
        return this.doExtractResultImpl(job, query, searchType, queryResult, queryContext);
    }

    public SearchType.Result doExtractResultImpl(SearchJob var1, Query var2, S var3, R var4, Q var5);
}

