/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.shiro.codec.Hex;
import org.cryptomator.siv.SivMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESTools {
    private static final Logger LOG = LoggerFactory.getLogger(AESTools.class);
    private static final SivMode SIV_MODE = new SivMode();

    @Nullable
    public static String encrypt(String plainText, String encryptionKey, String salt) {
        Preconditions.checkNotNull((Object)plainText, (Object)"Plain text must not be null.");
        Preconditions.checkNotNull((Object)encryptionKey, (Object)"Encryption key must not be null.");
        Preconditions.checkNotNull((Object)salt, (Object)"Salt must not be null.");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/ISO10126Padding", "SunJCE");
            SecretKeySpec key = new SecretKeySpec(AESTools.adjustToIdealKeyLength(encryptionKey), "AES");
            cipher.init(1, (Key)key, new IvParameterSpec(salt.getBytes("UTF-8")));
            return Hex.encodeToString((byte[])cipher.doFinal(plainText.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOG.error("Could not encrypt value.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String decrypt(String cipherText, String encryptionKey, String salt) {
        Preconditions.checkNotNull((Object)cipherText, (Object)"Cipher text must not be null.");
        Preconditions.checkNotNull((Object)encryptionKey, (Object)"Encryption key must not be null.");
        Preconditions.checkNotNull((Object)salt, (Object)"Salt must not be null.");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/ISO10126Padding", "SunJCE");
            SecretKeySpec key = new SecretKeySpec(AESTools.adjustToIdealKeyLength(encryptionKey), "AES");
            cipher.init(2, (Key)key, new IvParameterSpec(salt.getBytes("UTF-8")));
            return new String(cipher.doFinal(Hex.decode((String)cipherText)), "UTF-8");
        }
        catch (Exception e) {
            LOG.error("Could not decrypt value.", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String encryptSiv(String plainText, byte[] encryptionKey) {
        AESTools.validateTextAndEncryptionKey(plainText, encryptionKey);
        try {
            byte[] cipherBytes = SIV_MODE.encrypt(Arrays.copyOf(encryptionKey, 16), Arrays.copyOfRange(encryptionKey, 16, 32), plainText.getBytes(StandardCharsets.UTF_8), (byte[][])new byte[0][]);
            return Hex.encodeToString((byte[])cipherBytes);
        }
        catch (Exception e) {
            LOG.error("Couldn't encrypt value", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String decryptSiv(String cipherText, byte[] encryptionKey) {
        AESTools.validateTextAndEncryptionKey(cipherText, encryptionKey);
        try {
            byte[] plainBytes = SIV_MODE.decrypt(Arrays.copyOf(encryptionKey, 16), Arrays.copyOfRange(encryptionKey, 16, 32), Hex.decode((byte[])cipherText.getBytes(StandardCharsets.UTF_8)), (byte[][])new byte[0][]);
            return new String(plainBytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Couldn't decrypt value", (Throwable)e);
            return null;
        }
    }

    public static String generateNewSalt() {
        SecureRandom random = new SecureRandom();
        byte[] saltBytes = new byte[8];
        random.nextBytes(saltBytes);
        return Hex.encodeToString((byte[])saltBytes);
    }

    private static void validateTextAndEncryptionKey(String text, byte[] encryptionKey) {
        if (text == null) {
            throw new IllegalArgumentException("text value cannot be null");
        }
        if (encryptionKey == null || encryptionKey.length < 32) {
            throw new IllegalArgumentException("encryptionKey cannot be null and must be at least 32 bytes long");
        }
    }

    private static int desiredKeyLength(byte[] input) {
        int length = input.length;
        if (length == 16 || length == 24 || length == 32) {
            return length;
        }
        if (length < 16) {
            return 16;
        }
        if (length > 32) {
            return 32;
        }
        return (length / 8 + 1) * 8;
    }

    private static byte[] cutToLength(byte[] input, int length) {
        Preconditions.checkArgument((input.length >= length ? 1 : 0) != 0, (Object)"Input string must be greater or of desired length");
        return input.length > length ? Arrays.copyOfRange(input, 0, length) : input;
    }

    private static byte[] padToLength(byte[] input, int length) {
        Preconditions.checkArgument((input.length < length ? 1 : 0) != 0, (Object)"Input string must be smaller than desired length");
        byte[] result = new byte[length];
        System.arraycopy(input, 0, result, 0, input.length);
        return result;
    }

    private static byte[] cutOrPadToLength(byte[] input, int length) {
        if (input.length == length) {
            return input;
        }
        return input.length > length ? AESTools.cutToLength(input, length) : AESTools.padToLength(input, length);
    }

    private static byte[] adjustToIdealKeyLength(String input) {
        Preconditions.checkNotNull((Object)input);
        byte[] inputAsBytes = input.getBytes(StandardCharsets.UTF_8);
        int desiredLength = AESTools.desiredKeyLength(inputAsBytes);
        return AESTools.cutOrPadToLength(inputAsBytes, desiredLength);
    }
}

