/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.realm;

import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import java.util.Set;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.graylog2.Configuration;
import org.graylog2.plugin.inject.Graylog2Module;
import org.graylog2.security.realm.AccessTokenAuthenticator;
import org.graylog2.security.realm.LdapUserAuthenticator;
import org.graylog2.security.realm.PasswordAuthenticator;
import org.graylog2.security.realm.RootAccountRealm;
import org.graylog2.security.realm.SessionAuthenticator;

public class AuthenticatingRealmModule
extends Graylog2Module {
    private final Set<String> deactivatedRealms;

    public AuthenticatingRealmModule(Configuration configuration) {
        this.deactivatedRealms = configuration.getDeactivatedBuiltinAuthenticationProviders();
    }

    protected void configure() {
        MapBinder<String, AuthenticatingRealm> auth = this.authenticationRealmBinder();
        this.add(auth, "access-token", AccessTokenAuthenticator.class);
        this.add(auth, "root-user", RootAccountRealm.class);
        this.add(auth, "legacy-ldap", LdapUserAuthenticator.class);
        this.add(auth, "mongodb-password", PasswordAuthenticator.class);
        this.add(auth, "mongodb-session", SessionAuthenticator.class);
    }

    private void add(MapBinder<String, AuthenticatingRealm> auth, String name, Class<? extends AuthenticatingRealm> realm) {
        if (!this.deactivatedRealms.contains(name)) {
            auth.addBinding((Object)name).to(realm).in(Scopes.SINGLETON);
        }
    }
}

