/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog2.plugin.Message;

public class TrafficAccountingSize
extends AbstractFunction<Long> {
    public static final String NAME = "traffic_accounting_size";
    public static final String MESSAGE_ARG = "message";
    private final ParameterDescriptor<Message, Message> messageParam = ParameterDescriptor.type("message", Message.class).optional().description("The message to get the current accounting size for, defaults to '$message'").build();

    @Override
    public Long evaluate(FunctionArgs args, EvaluationContext context) {
        Message message = this.messageParam.optional(args, context).orElse(context.currentMessage());
        long size = message.getSize();
        return size;
    }

    @Override
    public FunctionDescriptor<Long> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Long.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam)).description("Calculates the current size of the message as used by the traffic accounting system.").build();
    }
}

