/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.dashboards.widgets.strategies;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Map;
import org.graylog2.dashboards.widgets.InvalidWidgetConfigurationException;
import org.graylog2.dashboards.widgets.strategies.QuickvaluesBaseWidgetStrategy;
import org.graylog2.indexer.searches.Searches;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.dashboards.widgets.ComputationResult;
import org.graylog2.plugin.dashboards.widgets.WidgetStrategy;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.rest.models.search.responses.TermsHistogramResult;
import org.graylog2.utilities.SearchUtils;

public class QuickvaluesHistogramWidgetStrategy
extends QuickvaluesBaseWidgetStrategy {
    private final int limit;
    private final Searches.DateHistogramInterval interval;

    @AssistedInject
    public QuickvaluesHistogramWidgetStrategy(Searches searches, @Assisted Map<String, Object> config, @Assisted TimeRange timeRange, @Assisted String widgetId) throws InvalidWidgetConfigurationException {
        super(searches, timeRange, config, widgetId);
        this.limit = (Integer)MoreObjects.firstNonNull((Object)config.get("limit"), (Object)5);
        this.interval = SearchUtils.buildInterval((String)config.get("interval"), timeRange);
    }

    @Override
    public ComputationResult compute() {
        String filter = null;
        if (!Strings.isNullOrEmpty((String)this.streamId)) {
            filter = "streams:" + this.streamId;
        }
        Sorting.Direction sortDirection = QuickvaluesHistogramWidgetStrategy.getSortingDirection(this.sortOrder);
        TermsHistogramResult termsHistogram = SearchUtils.buildTermsHistogramResult(this.searches.termsHistogram(this.field, this.stackedFields, this.limit, this.query, filter, this.timeRange, this.interval, sortDirection));
        return new ComputationResult(termsHistogram, termsHistogram.time());
    }

    public static interface Factory
    extends WidgetStrategy.Factory<QuickvaluesHistogramWidgetStrategy> {
        @Override
        public QuickvaluesHistogramWidgetStrategy create(Map<String, Object> var1, TimeRange var2, String var3);
    }
}

