/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog2.contentpacks.ContentPackInstallationPersistenceService;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackV1;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentPackLoaderPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(ContentPackLoaderPeriodical.class);
    private static final String FILENAME_GLOB = "*.json";
    private final ObjectMapper objectMapper;
    private final ContentPackService contentPackService;
    private final ContentPackPersistenceService contentPackPersistenceService;
    private final ContentPackInstallationPersistenceService contentPackInstallationPersistenceService;
    private final boolean contentPacksLoaderEnabled;
    private final Path contentPacksDir;
    private final Set<String> contentPacksAutoInstall;

    @Inject
    public ContentPackLoaderPeriodical(ObjectMapper objectMapper, ContentPackService contentPackService, ContentPackPersistenceService contentPackPersistenceService, ContentPackInstallationPersistenceService contentPackInstallationPersistenceService, @Named(value="content_packs_loader_enabled") boolean contentPacksLoaderEnabled, @Named(value="content_packs_dir") Path contentPacksDir, @Named(value="content_packs_auto_install") Set<String> contentPacksAutoInstall) {
        this.objectMapper = objectMapper;
        this.contentPackInstallationPersistenceService = contentPackInstallationPersistenceService;
        this.contentPackService = contentPackService;
        this.contentPackPersistenceService = contentPackPersistenceService;
        this.contentPacksLoaderEnabled = contentPacksLoaderEnabled;
        this.contentPacksDir = contentPacksDir;
        this.contentPacksAutoInstall = ImmutableSet.copyOf(contentPacksAutoInstall);
    }

    @Override
    public boolean runsForever() {
        return true;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean masterOnly() {
        return true;
    }

    @Override
    public boolean startOnThisNode() {
        return this.contentPacksLoaderEnabled;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void doRun() {
        String fileName;
        if (!Files.exists(this.contentPacksDir.toAbsolutePath(), new LinkOption[0])) {
            LOG.warn("Could not find content packs directory {}. Please check your graylog configuration", (Object)this.contentPacksDir.toAbsolutePath());
            return;
        }
        List<Path> files = this.getFiles(this.contentPacksDir);
        HashMap<String, ContentPack> contentPacks = new HashMap<String, ContentPack>(files.size());
        for (Path path : files) {
            Optional<ContentPack> existingContentPack;
            ContentPackV1 contentPackV1;
            ContentPack contentPack;
            byte[] bytes;
            fileName = path.getFileName().toString();
            LOG.debug("Reading content pack from {}", (Object)path);
            try {
                bytes = Files.readAllBytes(path);
            }
            catch (IOException e) {
                LOG.warn("Couldn't read " + path + ". Skipping.", (Throwable)e);
                continue;
            }
            LOG.debug("Parsing content pack from {}", (Object)path);
            try {
                contentPack = (ContentPack)this.objectMapper.readValue(bytes, ContentPack.class);
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse content pack in file " + path + ". Skipping", (Throwable)e);
                continue;
            }
            if (contentPack instanceof ContentPackV1 && (contentPackV1 = (ContentPackV1)contentPack).parameters().asList().size() > 0) {
                LOG.warn("Cannot accept content packs with parameters. Content Pack {}/{} rejected", (Object)contentPack.id(), (Object)contentPack.revision());
            }
            if ((existingContentPack = this.contentPackPersistenceService.findByIdAndRevision(contentPack.id(), contentPack.revision())).isPresent()) {
                LOG.debug("Content pack {}/{} already exists in database. Skipping.", (Object)contentPack.id(), (Object)contentPack.revision());
                contentPacks.put(fileName, existingContentPack.get());
                continue;
            }
            Optional<ContentPack> insertedContentPack = this.contentPackPersistenceService.insert(contentPack);
            if (!insertedContentPack.isPresent()) {
                LOG.error("Error while inserting content pack " + path + " into database. Skipping.");
                continue;
            }
            contentPacks.put(fileName, insertedContentPack.get());
        }
        LOG.debug("Applying selected content packs");
        for (Map.Entry entry : contentPacks.entrySet()) {
            fileName = (String)entry.getKey();
            ContentPack contentPack = (ContentPack)entry.getValue();
            if (!this.contentPacksAutoInstall.contains(fileName)) continue;
            if (!this.contentPackInstallationPersistenceService.findByContentPackIdAndRevision(contentPack.id(), contentPack.revision()).isEmpty()) {
                LOG.debug("Content pack {}/{} ({}) already applied. Skipping.", new Object[]{contentPack.id(), contentPack.revision(), fileName});
                continue;
            }
            this.contentPackService.installContentPack(contentPack, Collections.emptyMap(), "Installed by auto loader", "local:admin");
        }
    }

    private List<Path> getFiles(Path rootPath) {
        ImmutableList.Builder files = ImmutableList.builder();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(rootPath, FILENAME_GLOB);){
            for (Path path : directoryStream) {
                if (!Files.isReadable(path)) {
                    LOG.debug("Skipping unreadable file {}", (Object)path);
                }
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    LOG.debug("Path {} is not a regular file. Skipping.", (Object)path);
                }
                files.add((Object)path);
            }
        }
        catch (IOException e) {
            LOG.warn("Couldn't list content packs: {}", (Object)e.getMessage());
        }
        return files.build();
    }
}

