/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.event;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import org.graylog.events.event.EventDto;
import org.graylog.events.event.EventImpl;
import org.graylog.events.fields.FieldValue;
import org.graylog2.indexer.messages.Indexable;
import org.joda.time.DateTime;

public interface Event
extends Indexable {
    @Override
    public String getId();

    public String getEventDefinitionType();

    public String getEventDefinitionId();

    public String getOriginContext();

    public void setOriginContext(String var1);

    public DateTime getEventTimestamp();

    public void setEventTimestamp(DateTime var1);

    public DateTime getProcessingTimestamp();

    public void setProcessingTimestamp(DateTime var1);

    public DateTime getTimerangeStart();

    public void setTimerangeStart(DateTime var1);

    public DateTime getTimerangeEnd();

    public void setTimerangeEnd(DateTime var1);

    public ImmutableSet<String> getStreams();

    public void addStream(String var1);

    public void removeStream(String var1);

    public ImmutableSet<String> getSourceStreams();

    public void addSourceStream(String var1);

    public void removeSourceStream(String var1);

    public String getMessage();

    public void setMessage(String var1);

    public String getSource();

    public void setSource(String var1);

    public ImmutableList<String> getKeyTuple();

    public void setKeyTuple(List<String> var1);

    public long getPriority();

    public void setPriority(long var1);

    public boolean getAlert();

    public void setAlert(boolean var1);

    public FieldValue getField(String var1);

    public void setField(String var1, FieldValue var2);

    public void setFields(Map<String, String> var1);

    public boolean hasField(String var1);

    public EventDto toDto();

    public static Event fromDto(EventDto from) {
        EventImpl event = new EventImpl(from.id(), from.eventTimestamp(), from.eventDefinitionType(), from.eventDefinitionId(), from.message(), from.source(), from.priority(), from.alert());
        event.setProcessingTimestamp(from.processingTimestamp());
        event.setKeyTuple(from.keyTuple());
        from.streams().forEach(event::addStream);
        from.sourceStreams().forEach(event::addSourceStream);
        event.setFields(from.fields());
        event.setPriority(from.priority());
        from.timerangeStart().ifPresent(event::setTimerangeStart);
        from.timerangeEnd().ifPresent(event::setTimerangeEnd);
        from.originContext().ifPresent(event::setOriginContext);
        return event;
    }
}

