/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.time.ZonedDateTime;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.events.legacy.AutoValue_V20190722150700_LegacyAlertConditionMigration_MigrationCompleted;
import org.graylog.events.legacy.LegacyAlertConditionMigrator;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20190722150700_LegacyAlertConditionMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20190722150700_LegacyAlertConditionMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final LegacyAlertConditionMigrator legacyAlertConditionMigrator;

    @Inject
    public V20190722150700_LegacyAlertConditionMigration(ClusterConfigService clusterConfigService, LegacyAlertConditionMigrator legacyAlertConditionMigrator) {
        this.clusterConfigService = clusterConfigService;
        this.legacyAlertConditionMigrator = legacyAlertConditionMigrator;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-07-22T15:07:00Z");
    }

    @Override
    public void upgrade() {
        MigrationCompleted migrationCompleted = (MigrationCompleted)MoreObjects.firstNonNull((Object)this.clusterConfigService.get(MigrationCompleted.class), (Object)MigrationCompleted.create((ImmutableSet<String>)ImmutableSet.of(), (ImmutableSet<String>)ImmutableSet.of()));
        LegacyAlertConditionMigrator.MigrationResult result = this.legacyAlertConditionMigrator.run((Set<String>)migrationCompleted.completedAlertConditions(), (Set<String>)migrationCompleted.completedAlarmCallbacks());
        MigrationCompleted completed = MigrationCompleted.create(result.completedAlertConditions(), result.completedAlarmCallbacks());
        long migratedConditionCount = result.completedAlertConditions().size() - migrationCompleted.completedAlertConditions().size();
        long migratedCallbackCount = result.completedAlarmCallbacks().size() - migrationCompleted.completedAlarmCallbacks().size();
        if (migratedConditionCount > 0L || migratedCallbackCount > 0L) {
            LOG.info("Migrated <{}> legacy alert conditions and <{}> legacy alarm callbacks", (Object)migratedConditionCount, (Object)migratedCallbackCount);
        }
        this.clusterConfigService.write(completed);
    }

    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="completed_alert_conditions")
        public abstract ImmutableSet<String> completedAlertConditions();

        @JsonProperty(value="completed_alarm_callbacks")
        public abstract ImmutableSet<String> completedAlarmCallbacks();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="completed_alert_conditions") ImmutableSet<String> completedAlertConditions, @JsonProperty(value="completed_alarm_callbacks") ImmutableSet<String> completedAlarmCallbacks) {
            return new AutoValue_V20190722150700_LegacyAlertConditionMigration_MigrationCompleted(completedAlertConditions, completedAlarmCallbacks);
        }
    }
}

