/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.grn;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.graylog.grn.AutoValue_GRNType;
import org.graylog.grn.GRN;

@AutoValue
public abstract class GRNType {
    public abstract String type();

    public abstract String permissionPrefix();

    public GRN toGRN(String entity) {
        return this.newGRNBuilder().entity(entity).build();
    }

    public GRN.Builder newGRNBuilder() {
        return GRN.builder().type(this.type()).grnType(this);
    }

    public static GRNType create(String type, String permissionPrefix) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)type) ? 1 : 0) != 0, (Object)"type cannot be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)permissionPrefix) ? 1 : 0) != 0, (Object)"permissionPrefix cannot be null or empty");
        return new AutoValue_GRNType(type, permissionPrefix);
    }
}

