/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import java.util.Collections;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BaseExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarRefExpression
extends BaseExpression {
    private static final Logger log = LoggerFactory.getLogger(VarRefExpression.class);
    private final String identifier;
    private final Expression varExpr;
    private Class type = Object.class;

    public VarRefExpression(Token start, String identifier, Expression varExpr) {
        super(start);
        this.identifier = identifier;
        this.varExpr = varExpr;
    }

    @Override
    public boolean isConstant() {
        return this.varExpr != null && this.varExpr.isConstant();
    }

    @Override
    public Object evaluateUnsafe(EvaluationContext context) {
        EvaluationContext.TypedValue typedValue = context.get(this.identifier);
        if (typedValue != null) {
            return typedValue.getValue();
        }
        log.error("Unable to retrieve value for variable {}", (Object)this.identifier);
        return null;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public String toString() {
        return this.identifier;
    }

    public String varName() {
        return this.identifier;
    }

    public Expression varExpr() {
        return this.varExpr;
    }

    public void setType(Class type) {
        this.type = type;
    }

    @Override
    public Iterable<Expression> children() {
        return Collections.emptySet();
    }
}

