/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Length
extends AbstractFunction<Long> {
    public static final String NAME = "length";
    private static final String VALUE = "value";
    private static final String BYTES = "bytes";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("value").description("The input string").build();
    private final ParameterDescriptor<Boolean, Boolean> bytesParam = ParameterDescriptor.bool("bytes").description("If true, count the bytes of the UTF-8 string instead of the characters").optional().build();

    @Override
    public Long evaluate(FunctionArgs args, EvaluationContext context) {
        String string = Objects.requireNonNull(this.valueParam.required(args, context));
        Boolean bytesFlag = this.bytesParam.optional(args, context).orElse(Boolean.FALSE);
        if (bytesFlag.booleanValue()) {
            return string.getBytes(StandardCharsets.UTF_8).length;
        }
        return string.length();
    }

    @Override
    public FunctionDescriptor<Long> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Long.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.valueParam, this.bytesParam)).description("Counts the characters or bytes in a string").build();
    }
}

