/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.rest.models.ConfigurationVariable;
import org.graylog.plugins.sidecar.rest.models.Sidecar;
import org.graylog.plugins.sidecar.services.ConfigurationVariableService;
import org.graylog.plugins.sidecar.template.RenderTemplateException;
import org.graylog.plugins.sidecar.template.directives.IndentTemplateDirective;
import org.graylog.plugins.sidecar.template.loader.MongoDbTemplateLoader;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ConfigurationService
extends PaginatedDbService<org.graylog.plugins.sidecar.rest.models.Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationService.class);
    private static final Configuration templateConfiguration = new Configuration(Configuration.VERSION_2_3_28);
    private static final StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
    private ConfigurationVariableService configurationVariableService;
    private static final String COLLECTION_NAME = "sidecar_configurations";

    @Inject
    public ConfigurationService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ConfigurationVariableService configurationVariableService) {
        super(mongoConnection, mapper, org.graylog.plugins.sidecar.rest.models.Configuration.class, COLLECTION_NAME);
        MongoDbTemplateLoader mongoDbTemplateLoader = new MongoDbTemplateLoader((JacksonDBCollection<org.graylog.plugins.sidecar.rest.models.Configuration, ObjectId>)this.db);
        MultiTemplateLoader multiTemplateLoader = new MultiTemplateLoader(new TemplateLoader[]{mongoDbTemplateLoader, stringTemplateLoader});
        templateConfiguration.setTemplateLoader((TemplateLoader)multiTemplateLoader);
        templateConfiguration.setSharedVariable("indent", (TemplateModel)new IndentTemplateDirective());
        templateConfiguration.setDefaultEncoding("UTF-8");
        templateConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        templateConfiguration.setLogTemplateExceptions(false);
        this.configurationVariableService = configurationVariableService;
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration find(String id) {
        return (org.graylog.plugins.sidecar.rest.models.Configuration)this.db.findOne(DBQuery.is((String)"_id", (Object)id));
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration findByName(String name) {
        return (org.graylog.plugins.sidecar.rest.models.Configuration)this.db.findOne(DBQuery.is((String)"name", (Object)name));
    }

    public long count() {
        return this.db.count();
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> all() {
        try (Stream collectorConfigurationStream = this.streamAll();){
            List<org.graylog.plugins.sidecar.rest.models.Configuration> list = collectorConfigurationStream.collect(Collectors.toList());
            return list;
        }
    }

    public PaginatedList<org.graylog.plugins.sidecar.rest.models.Configuration> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(dbQuery, sortBuilder, page, perPage);
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> findByQuery(DBQuery.Query query) {
        try (Stream collectorConfigurationStream = this.streamQuery(query);){
            List<org.graylog.plugins.sidecar.rest.models.Configuration> list = collectorConfigurationStream.collect(Collectors.toList());
            return list;
        }
    }

    public List<org.graylog.plugins.sidecar.rest.models.Configuration> findByConfigurationVariable(ConfigurationVariable configurationVariable) {
        DBQuery.Query query = DBQuery.regex((String)"template", (Pattern)Pattern.compile(Pattern.quote(configurationVariable.fullName())));
        return this.findByQuery(query);
    }

    public void replaceVariableNames(String oldName, String newName) {
        DBQuery.Query query = DBQuery.regex((String)"template", (Pattern)Pattern.compile(Pattern.quote(oldName)));
        List<org.graylog.plugins.sidecar.rest.models.Configuration> configurations = this.findByQuery(query);
        for (org.graylog.plugins.sidecar.rest.models.Configuration config : configurations) {
            String newTemplate = config.template().replace(oldName, newName);
            this.db.findAndModify(DBQuery.is((String)"_id", (Object)config.id()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)config.toBuilder().template(newTemplate).build(), true, true);
        }
    }

    @Override
    public org.graylog.plugins.sidecar.rest.models.Configuration save(org.graylog.plugins.sidecar.rest.models.Configuration configuration) {
        return (org.graylog.plugins.sidecar.rest.models.Configuration)this.db.findAndModify(DBQuery.is((String)"_id", (Object)configuration.id()), (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject(), false, (Object)configuration, true, true);
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration copyConfiguration(String id, String name) {
        org.graylog.plugins.sidecar.rest.models.Configuration configuration = this.find(id);
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(configuration.collectorId(), name, configuration.color(), configuration.template());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration fromRequest(org.graylog.plugins.sidecar.rest.models.Configuration request) {
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(request.collectorId(), request.name(), request.color(), request.template());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration fromRequest(String id, org.graylog.plugins.sidecar.rest.models.Configuration request) {
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(id, request.collectorId(), request.name(), request.color(), request.template());
    }

    public org.graylog.plugins.sidecar.rest.models.Configuration renderConfigurationForCollector(Sidecar sidecar, org.graylog.plugins.sidecar.rest.models.Configuration configuration) throws RenderTemplateException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("nodeId", sidecar.nodeId());
        context.put("nodeName", sidecar.nodeName());
        context.put("sidecarVersion", sidecar.sidecarVersion());
        context.put("operatingSystem", sidecar.nodeDetails().operatingSystem());
        return org.graylog.plugins.sidecar.rest.models.Configuration.create(configuration.id(), configuration.collectorId(), configuration.name(), configuration.color(), this.renderTemplate(configuration.id(), context));
    }

    public String renderPreview(String template) throws RenderTemplateException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("nodeId", "<node id>");
        context.put("nodeName", "<node name>");
        context.put("sidecarVersion", "<version>");
        context.put("operatingSystem", "<operating system>");
        String previewName = UUID.randomUUID().toString();
        stringTemplateLoader.putTemplate(previewName, template);
        String result = this.renderTemplate(previewName, context);
        stringTemplateLoader.removeTemplate(previewName);
        try {
            templateConfiguration.removeTemplateFromCache(previewName);
        }
        catch (IOException e) {
            LOG.debug("Couldn't remove temporary template from cache: " + e.getMessage());
        }
        return result;
    }

    private String renderTemplate(String configurationId, Map<String, Object> sidecarContext) throws RenderTemplateException {
        StringWriter writer = new StringWriter();
        HashMap<String, Map<String, Object>> context = new HashMap<String, Map<String, Object>>();
        context.put("sidecar", sidecarContext);
        Map<String, Object> userContext = this.configurationVariableService.all().stream().collect(Collectors.toMap(ConfigurationVariable::name, ConfigurationVariable::content));
        context.put("user", userContext);
        try {
            Template compiledTemplate = templateConfiguration.getTemplate(configurationId);
            compiledTemplate.process(context, (Writer)writer);
        }
        catch (TemplateException e) {
            LOG.error("Failed to render template: " + e.getMessageWithoutStackTop());
            throw new RenderTemplateException(e.getFTLInstructionStack(), e);
        }
        catch (IOException e) {
            LOG.error("Failed to render template: ", (Throwable)e);
            throw new RenderTemplateException(e.getMessage(), e);
        }
        String template = ((Object)writer).toString();
        return template.endsWith("\n") ? template : template + "\n";
    }
}

