/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.elasticsearch;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.views.search.QueryMetadata;

public class QueryStringParser {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$(.+?)\\$");

    public QueryMetadata parse(String queryString) {
        if (Strings.isNullOrEmpty((String)queryString)) {
            return QueryMetadata.empty();
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(queryString);
        HashSet paramNames = Sets.newHashSet();
        while (matcher.find()) {
            String name = matcher.group(1);
            paramNames.add(name);
        }
        return QueryMetadata.builder().usedParameterNames((Set<String>)ImmutableSet.copyOf((Collection)paramNames)).build();
    }
}

