/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import java.util.Optional;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.AuthServiceResult;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog.security.authservice.UserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthServiceAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(AuthServiceAuthenticator.class);
    private final GlobalAuthServiceConfig authServiceConfig;
    private final ProvisionerService provisionerService;

    @Inject
    public AuthServiceAuthenticator(GlobalAuthServiceConfig authServiceConfig, ProvisionerService provisionerService) {
        this.authServiceConfig = authServiceConfig;
        this.provisionerService = provisionerService;
    }

    public AuthServiceResult authenticate(AuthServiceCredentials authCredentials) {
        Optional<AuthServiceBackend> activeBackend = this.authServiceConfig.getActiveBackend();
        if (activeBackend.isPresent()) {
            AuthServiceResult result = this.authenticate(authCredentials, activeBackend.get());
            if (result.isSuccess()) {
                return result;
            }
            if (LOG.isDebugEnabled()) {
                AuthServiceBackend defaultBackend = this.authServiceConfig.getDefaultBackend();
                LOG.debug("Couldn't authenticate <{}> against active authentication service <{}/{}/{}>. Trying default backend <{}/{}/{}>.", new Object[]{authCredentials.username(), activeBackend.get().backendId(), activeBackend.get().backendType(), activeBackend.get().backendTitle(), defaultBackend.backendId(), defaultBackend.backendType(), defaultBackend.backendTitle()});
            }
        }
        return this.authenticate(authCredentials, this.authServiceConfig.getDefaultBackend());
    }

    private AuthServiceResult authenticate(AuthServiceCredentials authCredentials, AuthServiceBackend backend) {
        Optional<UserDetails> userDetails = backend.authenticateAndProvision(authCredentials, this.provisionerService);
        if (userDetails.isPresent()) {
            return AuthServiceResult.builder().username(authCredentials.username()).userProfileId(userDetails.get().databaseId().get()).backendType(backend.backendType()).backendId(backend.backendId()).backendTitle(backend.backendTitle()).build();
        }
        return this.failResult(authCredentials, backend);
    }

    private AuthServiceResult failResult(AuthServiceCredentials authCredentials, AuthServiceBackend backend) {
        return AuthServiceResult.failed(authCredentials.username(), backend);
    }
}

