/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice;

import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AutoValue_AuthServiceResult;

@AutoValue
public abstract class AuthServiceResult {
    public abstract String username();

    @Nullable
    public abstract String userProfileId();

    public abstract String backendId();

    public abstract String backendType();

    public abstract String backendTitle();

    public boolean isSuccess() {
        return !Strings.isNullOrEmpty((String)this.userProfileId());
    }

    public static Builder builder() {
        return new AutoValue_AuthServiceResult.Builder();
    }

    public static AuthServiceResult failed(String username, AuthServiceBackend backend) {
        return AuthServiceResult.builder().username(username).backendId(backend.backendId()).backendType(backend.backendType()).backendTitle(backend.backendTitle()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder username(String var1);

        public abstract Builder userProfileId(String var1);

        public abstract Builder backendId(String var1);

        public abstract Builder backendType(String var1);

        public abstract Builder backendTitle(String var1);

        public abstract AuthServiceResult build();
    }
}

