/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.backend;

import com.unboundid.util.Base64;
import java.util.Collections;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.security.authservice.AuthServiceBackend;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceCredentials;
import org.graylog.security.authservice.ProvisionerService;
import org.graylog.security.authservice.UserDetails;
import org.graylog.security.authservice.test.AuthServiceBackendTestResult;
import org.graylog2.plugin.database.users.User;
import org.graylog2.plugin.security.PasswordAlgorithm;
import org.graylog2.security.PasswordAlgorithmFactory;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBAuthServiceBackend
implements AuthServiceBackend {
    public static final String NAME = "internal-mongodb";
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBAuthServiceBackend.class);
    private final UserService userService;
    private final EncryptedValueService encryptedValueService;
    private final PasswordAlgorithmFactory passwordAlgorithmFactory;

    @Inject
    public MongoDBAuthServiceBackend(UserService userService, EncryptedValueService encryptedValueService, PasswordAlgorithmFactory passwordAlgorithmFactory) {
        this.userService = userService;
        this.encryptedValueService = encryptedValueService;
        this.passwordAlgorithmFactory = passwordAlgorithmFactory;
    }

    @Override
    public Optional<UserDetails> authenticateAndProvision(AuthServiceCredentials authCredentials, ProvisionerService provisionerService) {
        String username = authCredentials.username();
        LOG.debug("Trying to load user <{}> from database", (Object)username);
        User user = this.userService.load(username);
        if (user == null) {
            LOG.warn("User <{}> not found in database", (Object)username);
            return Optional.empty();
        }
        if (user.isLocalAdmin()) {
            throw new IllegalStateException("Local admin user should have been handled earlier and not reach the authentication service authenticator");
        }
        if (user.isExternalUser()) {
            LOG.trace("Skipping mongodb-based password check for external user {}", (Object)authCredentials.username());
            return Optional.empty();
        }
        if (!authCredentials.isAuthenticated() && !this.isValidPassword(user, authCredentials.password())) {
            LOG.warn("Failed to validate password for user <{}>", (Object)username);
            return Optional.empty();
        }
        LOG.debug("Successfully validated password for user <{}>", (Object)username);
        UserDetails userDetails = provisionerService.provision(provisionerService.newDetails(this).databaseId(user.getId()).username(user.getName()).email(user.getEmail()).fullName(user.getFullName()).defaultRoles(Collections.emptySet()).base64AuthServiceUid(Base64.encode((String)user.getId())).build());
        return Optional.of(userDetails);
    }

    private boolean isValidPassword(User user, EncryptedValue password) {
        PasswordAlgorithm passwordAlgorithm = this.passwordAlgorithmFactory.forPassword(user.getHashedPassword());
        if (passwordAlgorithm == null) {
            return false;
        }
        return passwordAlgorithm.matches(user.getHashedPassword(), this.encryptedValueService.decrypt(password));
    }

    @Override
    public String backendType() {
        return NAME;
    }

    @Override
    public String backendId() {
        return "000000000000000000000001";
    }

    @Override
    public String backendTitle() {
        return "Internal MongoDB";
    }

    @Override
    public AuthServiceBackendDTO prepareConfigUpdate(AuthServiceBackendDTO existingBackend, AuthServiceBackendDTO newBackend) {
        return newBackend;
    }

    @Override
    public AuthServiceBackendTestResult testConnection(@Nullable AuthServiceBackendDTO existingBackendConfig) {
        return AuthServiceBackendTestResult.createFailure("Not implemented");
    }

    @Override
    public AuthServiceBackendTestResult testLogin(AuthServiceCredentials credentials, @Nullable AuthServiceBackendDTO existingConfig) {
        return AuthServiceBackendTestResult.createFailure("Not implemented");
    }
}

