/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.ldap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.security.authservice.ldap.AutoValue_LDAPConnectorConfig;
import org.graylog.security.authservice.ldap.AutoValue_LDAPConnectorConfig_LDAPServer;
import org.graylog.security.authservice.ldap.LDAPTransportSecurity;
import org.graylog2.security.encryption.EncryptedValue;

@AutoValue
public abstract class LDAPConnectorConfig {
    public abstract Optional<String> systemUsername();

    public abstract EncryptedValue systemPassword();

    public abstract ImmutableList<LDAPServer> serverList();

    public abstract LDAPTransportSecurity transportSecurity();

    public abstract boolean verifyCertificates();

    public static Builder builder() {
        return Builder.create();
    }

    @AutoValue
    public static abstract class LDAPServer {
        public static final String FIELD_HOSTNAME = "hostname";
        public static final String FIELD_PORT = "port";

        @JsonProperty(value="hostname")
        public abstract String hostname();

        @JsonProperty(value="port")
        public abstract int port();

        public static LDAPServer create(String hostname, int port) {
            return new AutoValue_LDAPConnectorConfig_LDAPServer(hostname, port);
        }

        public static LDAPServer fromUrl(String url) {
            URI uri = URI.create(url);
            return LDAPServer.create(uri.getHost(), uri.getPort());
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public static Builder create() {
            return new AutoValue_LDAPConnectorConfig.Builder().systemPassword(EncryptedValue.createUnset());
        }

        public abstract Builder systemUsername(@Nullable String var1);

        public abstract Builder systemPassword(EncryptedValue var1);

        public abstract Builder serverList(List<LDAPServer> var1);

        public abstract Builder transportSecurity(LDAPTransportSecurity var1);

        public abstract Builder verifyCertificates(boolean var1);

        public abstract LDAPConnectorConfig build();
    }
}

