/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.AuthServiceBackendDTO;
import org.graylog.security.authservice.AuthServiceBackendUsageCheck;
import org.graylog.security.authservice.DBAuthServiceBackendService;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.rest.ValidationFailureException;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.rest.PaginationParameters;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/system/authentication/services/backends")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services/Backends", description="Manage authentication service backends")
@RequiresAuthentication
public class AuthServiceBackendsResource
extends RestResource {
    private final DBAuthServiceBackendService dbService;
    private final GlobalAuthServiceConfig globalAuthServiceConfig;
    private final AuthServiceBackendUsageCheck usageCheck;

    @Inject
    public AuthServiceBackendsResource(DBAuthServiceBackendService dbService, GlobalAuthServiceConfig globalAuthServiceConfig, AuthServiceBackendUsageCheck usageCheck) {
        this.dbService = dbService;
        this.globalAuthServiceConfig = globalAuthServiceConfig;
        this.usageCheck = usageCheck;
    }

    @GET
    @ApiOperation(value="Returns available authentication service backends")
    public PaginatedResponse<AuthServiceBackendDTO> list(@ApiParam(name="pagination parameters") @BeanParam PaginationParameters paginationParameters) {
        AuthServiceBackendDTO activeBackendConfig = this.globalAuthServiceConfig.getActiveBackendConfig().filter(this::checkReadPermission).orElse(null);
        PaginatedList<AuthServiceBackendDTO> list = this.dbService.findPaginated(paginationParameters, this::checkReadPermission);
        return PaginatedResponse.create("backends", list, Collections.singletonMap("active_backend", activeBackendConfig));
    }

    @GET
    @Path(value="{backendId}")
    @ApiOperation(value="Returns the authentication service backend for the given ID")
    public Response get(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId) {
        this.checkPermission("authservicebackend:read", backendId);
        return this.toResponse(this.loadConfig(backendId));
    }

    @POST
    @ApiOperation(value="Creates a new authentication service backend")
    @RequiresPermissions(value={"authservicebackend:create"})
    @AuditEvent(type="security:auth_service_backend:create")
    public Response create(@ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendDTO newConfig) {
        this.validateConfig(newConfig);
        return this.toResponse(this.dbService.save(newConfig));
    }

    @PUT
    @Path(value="{backendId}")
    @ApiOperation(value="Updates an existing authentication service backend")
    @AuditEvent(type="security:auth_service_backend:update")
    public Response update(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId, @ApiParam(name="JSON body", required=true) @NotNull AuthServiceBackendDTO updatedConfig) {
        this.checkPermission("authservicebackend:edit", backendId);
        this.validateConfig(updatedConfig);
        AuthServiceBackendDTO currentConfig = this.loadConfig(backendId);
        return this.toResponse(this.dbService.save(updatedConfig.withId(currentConfig.id())));
    }

    @DELETE
    @Path(value="{backendId}")
    @ApiOperation(value="Delete authentication service backend")
    @AuditEvent(type="security:auth_service_backend:delete")
    public void delete(@ApiParam(name="backendId", required=true) @PathParam(value="backendId") @NotBlank String backendId) {
        this.checkPermission("authservicebackend:delete", backendId);
        AuthServiceBackendDTO config = this.loadConfig(backendId);
        if (this.usageCheck.isAuthServiceInUse(backendId)) {
            throw new BadRequestException("Authentication service backend <" + backendId + "> is still in use");
        }
        this.dbService.delete(config.id());
    }

    private boolean checkReadPermission(AuthServiceBackendDTO config) {
        return this.isPermitted("authservicebackend:read", config.id());
    }

    private AuthServiceBackendDTO loadConfig(String backendId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backendId) ? 1 : 0) != 0, (Object)"backendId cannot be null or empty");
        return (AuthServiceBackendDTO)this.dbService.get(backendId).orElseThrow(() -> new NotFoundException("Couldn't find auth service backend " + backendId));
    }

    private void validateConfig(AuthServiceBackendDTO config) {
        ValidationResult result = config.validate();
        if (result.failed()) {
            throw new ValidationFailureException(result);
        }
    }

    private Response toResponse(Object entity) {
        return Response.ok(Collections.singletonMap("backend", entity)).build();
    }
}

