/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.authservice.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.security.authservice.GlobalAuthServiceConfig;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.shared.rest.resources.RestResource;

@Path(value="/system/authentication/services/configuration")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="System/Authentication/Services/Configuration", description="Manage global authentication services configuration")
@RequiresAuthentication
public class GlobalAuthServiceConfigResource
extends RestResource {
    private final GlobalAuthServiceConfig authServiceConfig;

    @Inject
    public GlobalAuthServiceConfigResource(GlobalAuthServiceConfig authServiceConfig) {
        this.authServiceConfig = authServiceConfig;
    }

    @GET
    @ApiOperation(value="Get global authentication services configuration")
    @RequiresPermissions(value={"authserviceglobalconfig:read"})
    public Response get() {
        return this.toResponse(this.authServiceConfig.getConfiguration());
    }

    @POST
    @ApiOperation(value="Update global authentication services configuration")
    @RequiresPermissions(value={"authserviceglobalconfig:edit"})
    @AuditEvent(type="security:auth_service_global_config:update")
    public Response update(@ApiParam(name="JSON body", required=true) @NotNull GlobalAuthServiceConfig.Data body) {
        return this.toResponse(this.authServiceConfig.updateConfiguration(body));
    }

    private Response toResponse(GlobalAuthServiceConfig.Data configuration) {
        return Response.ok(Collections.singletonMap("configuration", configuration)).build();
    }
}

