/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.entities;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.grn.GRN;
import org.graylog.security.BuiltinCapabilities;
import org.graylog.security.Capability;
import org.graylog.security.CapabilityDescriptor;
import org.graylog.security.GranteeAuthorizer;
import org.graylog.security.entities.EntityDescriptor;

public class EntityDependencyPermissionChecker {
    private final GranteeAuthorizer.Factory granteeAuthorizerFactory;
    private final BuiltinCapabilities builtinCapabilities;

    @Inject
    public EntityDependencyPermissionChecker(GranteeAuthorizer.Factory granteeAuthorizerFactory, BuiltinCapabilities builtinCapabilities) {
        this.granteeAuthorizerFactory = granteeAuthorizerFactory;
        this.builtinCapabilities = builtinCapabilities;
    }

    public ImmutableMultimap<GRN, EntityDescriptor> check(GRN sharingUser, ImmutableSet<EntityDescriptor> dependencies, Set<GRN> selectedGrantees) {
        ImmutableMultimap.Builder deniedDependencies = ImmutableMultimap.builder();
        GranteeAuthorizer sharerAuthorizer = this.granteeAuthorizerFactory.create(sharingUser);
        for (GRN grantee : selectedGrantees) {
            GranteeAuthorizer granteeAuthorizer = this.granteeAuthorizerFactory.create(grantee);
            for (EntityDescriptor dependency : dependencies) {
                if (this.cannotView(sharerAuthorizer, dependency) || !this.cannotView(granteeAuthorizer, dependency)) continue;
                deniedDependencies.put((Object)grantee, (Object)dependency);
            }
        }
        return deniedDependencies.build();
    }

    private boolean cannotView(GranteeAuthorizer authorizer, EntityDescriptor dependency) {
        Optional<CapabilityDescriptor> capabilityDescriptor = this.builtinCapabilities.get(Capability.VIEW);
        return capabilityDescriptor.map(CapabilityDescriptor::permissions).orElse(Collections.emptySet()).stream().filter(permission -> dependency.id().isPermissionApplicable((String)permission)).noneMatch(permission -> authorizer.isPermitted((String)permission, dependency.id()));
    }
}

