/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import org.graylog.grn.GRN;
import org.graylog.security.entities.AutoValue_EntityDescriptor;
import org.graylog.security.entities.AutoValue_EntityDescriptor_Owner;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EntityDescriptor {
    @JsonProperty(value="id")
    public abstract GRN id();

    @JsonProperty(value="type")
    public String type() {
        return this.id().type();
    }

    @JsonProperty(value="title")
    public abstract String title();

    @JsonProperty(value="owners")
    public abstract ImmutableSet<Owner> owners();

    public static EntityDescriptor create(GRN id, String title, Set<Owner> owners) {
        return EntityDescriptor.builder().id(id).title(title).owners(owners).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @AutoValue
    public static abstract class Owner {
        @JsonProperty(value="id")
        public abstract GRN id();

        @JsonProperty(value="type")
        public String type() {
            return this.id().type();
        }

        @JsonProperty(value="title")
        public abstract String title();

        @JsonCreator
        public static Owner create(GRN id, String title) {
            return new AutoValue_EntityDescriptor_Owner(id, title);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EntityDescriptor.Builder().owners(Collections.emptySet());
        }

        @JsonProperty(value="id")
        public abstract Builder id(GRN var1);

        @JsonProperty(value="title")
        public abstract Builder title(String var1);

        @JsonProperty(value="owners")
        public abstract Builder owners(Set<Owner> var1);

        public abstract EntityDescriptor build();
    }
}

